/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.mybatis.plugin;

import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.joda.time.DateTime;
import org.springframework.data.domain.Auditable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MyBatisAuditAwarePlugin
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        DefaultParameterHandler paramHandler;
        Object obj;
        if (target instanceof DefaultParameterHandler && (obj = (paramHandler = (DefaultParameterHandler)target).getParameterObject()) != null && obj instanceof Auditable) {
            DateTime currentTimeStamp = new DateTime();
            String currentUser = this.getCurrentLoginUser();
            Auditable auditable = (Auditable)obj;
            if (auditable.getCreatedDate() == null) {
                auditable.setCreatedDate(currentTimeStamp);
                auditable.setCreatedBy((Object)currentUser);
            }
            auditable.setLastModifiedBy((Object)currentUser);
            auditable.setLastModifiedDate(currentTimeStamp);
        }
        return target;
    }

    private String getCurrentLoginUser() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            return null;
        }
        if (authentication instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)authentication;
            return userDetails.getUsername();
        }
        return authentication.getName();
    }

    public void setProperties(Properties properties) {
    }
}

