/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.validator.collection.internal;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.HibernateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HibernateValidatorInfo {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateValidatorInfo.class);

    public static int getVersion() {
        Package pkg = HibernateValidator.class.getPackage();
        if (pkg != null) {
            String version = pkg.getImplementationVersion();
            String title = pkg.getImplementationTitle();
            if (StringUtils.isNotEmpty((CharSequence)version) && "hibernate-validator".equals(title)) {
                LOG.info("Found Hibernate Validator {}", (Object)version);
                return HibernateValidatorInfo.parseVersion(version);
            }
        }
        LOG.warn("Could not determine Hibernate Validator version");
        return Integer.MAX_VALUE;
    }

    static int parseVersion(String version) {
        String[] tokens = version.split("[.-]");
        return Integer.parseInt(tokens[0]) * 100 + Integer.parseInt(tokens[1]) * 10 + Integer.parseInt(tokens[2]);
    }
}

