/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryFactory;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.NamedQuery;
import org.springframework.data.jpa.repository.query.PartTreeJpaQuery;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public final class JpaQueryLookupStrategy {
    private JpaQueryLookupStrategy() {
    }

    public static QueryLookupStrategy create(EntityManager em, QueryLookupStrategy.Key key, QueryExtractor extractor, EvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Assert.notNull((Object)extractor, (String)"QueryExtractor must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        switch (key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND) {
            case CREATE: {
                return new CreateQueryLookupStrategy(em, extractor);
            }
            case USE_DECLARED_QUERY: {
                return new DeclaredQueryLookupStrategy(em, extractor, evaluationContextProvider);
            }
            case CREATE_IF_NOT_FOUND: {
                return new CreateIfNotFoundQueryLookupStrategy(em, extractor, new CreateQueryLookupStrategy(em, extractor), new DeclaredQueryLookupStrategy(em, extractor, evaluationContextProvider));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", key));
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, QueryExtractor extractor, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy) {
            super(em, extractor);
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, em, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, em, namedQueries);
            }
        }
    }

    private static class DeclaredQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final EvaluationContextProvider evaluationContextProvider;

        public DeclaredQueryLookupStrategy(EntityManager em, QueryExtractor extractor, EvaluationContextProvider evaluationContextProvider) {
            super(em, extractor);
            this.evaluationContextProvider = evaluationContextProvider;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            AbstractJpaQuery query = JpaQueryFactory.INSTANCE.fromQueryAnnotation(method, em, this.evaluationContextProvider);
            if (null != query) {
                return query;
            }
            query = JpaQueryFactory.INSTANCE.fromProcedureAnnotation(method, em);
            if (null != query) {
                return query;
            }
            String name = method.getNamedQueryName();
            if (namedQueries.hasQuery(name)) {
                return JpaQueryFactory.INSTANCE.fromMethodWithQueryString(method, em, namedQueries.getQuery(name), this.evaluationContextProvider);
            }
            query = NamedQuery.lookupFrom(method, em);
            if (null != query) {
                return query;
            }
            throw new IllegalStateException(String.format("Did neither find a NamedQuery nor an annotated query for method %s!", new Object[]{method}));
        }
    }

    private static class CreateQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        public CreateQueryLookupStrategy(EntityManager em, QueryExtractor extractor) {
            super(em, extractor);
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            try {
                return new PartTreeJpaQuery(method, em);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Could not create query metamodel for method %s!", method.toString()), e);
            }
        }
    }

    private static abstract class AbstractQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final QueryExtractor provider;

        public AbstractQueryLookupStrategy(EntityManager em, QueryExtractor extractor) {
            this.em = em;
            this.provider = extractor;
        }

        public final RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            return this.resolveQuery(new JpaQueryMethod(method, metadata, this.provider), this.em, namedQueries);
        }

        protected abstract RepositoryQuery resolveQuery(JpaQueryMethod var1, EntityManager var2, NamedQueries var3);
    }
}

