/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.Select;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;

class Values<R extends Record>
extends AbstractTable<R> {
    private static final long serialVersionUID = -637982217747670311L;
    private final Row[] rows;

    Values(Row[] rows) {
        super("values");
        this.rows = Values.assertNotEmpty(rows);
    }

    static Row[] assertNotEmpty(Row[] rows) {
        if (rows == null || rows.length == 0) {
            throw new IllegalArgumentException("Cannot create a VALUES() constructor with an empty set of rows");
        }
        return rows;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public final Table<R> as(String alias) {
        return new TableAlias(this, alias, true);
    }

    @Override
    public final Table<R> as(String alias, String ... fieldAliases) {
        return new TableAlias(this, alias, fieldAliases, true);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: 
            case H2: {
                Select<Record> selects = null;
                boolean subquery = ctx.subquery();
                for (Row row : this.rows) {
                    SelectSelectStep<Record> select = this.create().select(row.fields());
                    selects = selects == null ? select : selects.unionAll(select);
                }
                ctx.formatIndentStart().formatNewLine().subquery(true).visit(selects).subquery(subquery).formatIndentEnd().formatNewLine();
                break;
            }
            default: {
                ctx.start(Clause.TABLE_VALUES).keyword("values").formatIndentLockStart();
                boolean firstRow = true;
                for (Row row : this.rows) {
                    if (!firstRow) {
                        ctx.sql(',').formatSeparator();
                    }
                    ctx.visit(row);
                    firstRow = false;
                }
                ctx.formatIndentLockEnd().end(Clause.TABLE_VALUES);
                break;
            }
        }
    }

    @Override
    final Fields<R> fields0() {
        return new Fields(this.rows[0].fields());
    }
}

