/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropSequenceFinalStep;
import org.jooq.SQLDialect;
import org.jooq.Sequence;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DropStatementType;
import org.jooq.impl.Utils;

class DropSequenceImpl
extends AbstractQuery
implements DropSequenceFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_SEQUENCE};
    private final Sequence<?> sequence;
    private final boolean ifExists;

    DropSequenceImpl(Configuration configuration, Sequence<?> sequence) {
        this(configuration, sequence, false);
    }

    DropSequenceImpl(Configuration configuration, Sequence<?> sequence, boolean ifExists) {
        super(configuration);
        this.sequence = sequence;
        this.ifExists = ifExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Utils.executeImmediateBegin(ctx, DropStatementType.SEQUENCE);
            this.accept0(ctx);
            Utils.executeImmediateEnd(ctx, DropStatementType.SEQUENCE);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_SEQUENCE_SEQUENCE).keyword("drop").sql(' ').keyword(ctx.family() == SQLDialect.CUBRID ? "serial" : "sequence").sql(' ');
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.keyword("if exists").sql(' ');
        }
        ctx.visit(this.sequence);
        if (ctx.family() == SQLDialect.DERBY) {
            ctx.sql(' ').keyword("restrict");
        }
        ctx.end(Clause.DROP_SEQUENCE_SEQUENCE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

