/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jooq.Converter;
import org.jooq.ConverterProvider;
import org.jooq.Converters;
import org.jooq.tools.StringUtils;

@Deprecated
public class DefaultConverterProvider
implements ConverterProvider {
    final Graph graph = new Graph();

    @Override
    public <T, U> Converter<T, U> provide(Class<T> tType, Class<U> uType) {
        if (tType == uType) {
            return Converters.identity(tType);
        }
        return this.graph.get(new Endpoints<T, U>(tType, uType));
    }

    public <T, U> void add(Converter<T, U> converter) {
        this.graph.add(converter);
    }

    public String toString() {
        return this.graph.toString();
    }

    static class Endpoints<T, U> {
        final Class<T> fromType;
        final Class<U> toType;

        Endpoints(Class<T> t, Class<U> u) {
            this.fromType = t;
            this.toType = u;
        }

        public int hashCode() {
            return 17 * this.fromType.hashCode() + this.toType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Endpoints) {
                Endpoints that = (Endpoints)obj;
                return this.fromType == that.fromType && this.toType == that.toType;
            }
            return false;
        }

        public String toString() {
            return "(" + this.fromType.getName() + ", " + this.toType.getName() + ")";
        }
    }

    static class Graph {
        final Set<Class<?>> vertices = new HashSet();
        final Map<Class<?>, Set<Converter<?, ?>>> adjacency = new HashMap();
        final Map<Endpoints<?, ?>, Converter<?, ?>> paths = new ConcurrentHashMap();

        Graph() {
        }

        <T, U> Converter<T, U> get(Endpoints<T, U> classes) {
            this.build();
            return this.paths.get(classes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T, U> void add(Converter<T, U> converter) {
            Map<Endpoints<?, ?>, Converter<?, ?>> map = this.paths;
            synchronized (map) {
                this.paths.clear();
                Class<T> t = converter.fromType();
                Class<U> u = converter.toType();
                this.vertices.add(t);
                this.vertices.add(u);
                Set<Converter<?, ?>> tSet = this.adjacency.get(t);
                if (tSet == null) {
                    tSet = new HashSet();
                    this.adjacency.put(t, tSet);
                }
                tSet.add(converter);
                Set<Converter<?, ?>> uSet = this.adjacency.get(u);
                if (uSet == null) {
                    uSet = new HashSet();
                    this.adjacency.put(u, uSet);
                }
                uSet.add(Converters.inverse(converter));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void build() {
            if (this.paths.isEmpty()) {
                Map<Endpoints<?, ?>, Converter<?, ?>> map = this.paths;
                synchronized (map) {
                    int size;
                    for (Map.Entry<Class<?>, Set<Converter<?, ?>>> entry : this.adjacency.entrySet()) {
                        for (Converter<?, ?> converter : entry.getValue()) {
                            this.path(new Endpoints(converter.fromType(), converter.toType()), converter);
                        }
                    }
                    do {
                        size = this.paths.size();
                        ArrayList keys = new ArrayList(this.paths.keySet());
                        for (Endpoints endpoints : keys) {
                            for (Converter<?, ?> converter : this.adjacency.get(endpoints.toType)) {
                                this.path(new Endpoints(endpoints.fromType, converter.toType()), Converters.of(this.paths.get(endpoints), converter));
                            }
                        }
                    } while (size < this.paths.size());
                }
            }
        }

        private void path(Endpoints<?, ?> key, Converter<?, ?> converter) {
            if (key.fromType != key.toType && !this.paths.containsKey(key)) {
                this.paths.put(key, converter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            this.build();
            Map<Endpoints<?, ?>, Converter<?, ?>> map = this.paths;
            synchronized (map) {
                StringBuilder sb = new StringBuilder();
                Class[] classes = this.vertices.toArray(new Class[0]);
                Arrays.sort(classes, new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class<?> o1, Class<?> o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                int maxLength = Integer.MIN_VALUE;
                for (Class c : classes) {
                    maxLength = Math.max(maxLength, c.getName().length());
                }
                String sep1 = "";
                for (Class c1 : classes) {
                    sb.append(sep1);
                    sb.append(StringUtils.rightPad(c1.getName(), maxLength));
                    for (Class c2 : classes) {
                        if (!this.paths.containsKey(new Endpoints(c1, c2))) continue;
                        sb.append("\n -> ").append(c2.getName());
                    }
                    sep1 = "\n\n";
                }
                return sb.toString();
            }
        }
    }
}

