/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.AlterTableAlterStep;
import org.jooq.AlterTableDropStep;
import org.jooq.AlterTableFinalStep;
import org.jooq.AlterTableStep;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Utils;

class AlterTableImpl
extends AbstractQuery
implements AlterTableStep,
AlterTableDropStep,
AlterTableAlterStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_TABLE};
    private final Table<?> table;
    private Field<?> addColumn;
    private DataType<?> addColumnType;
    private Constraint addConstraint;
    private Field<?> alterColumn;
    private DataType<?> alterColumnType;
    private Field<?> alterColumnDefault;
    private Field<?> dropColumn;
    private boolean dropColumnCascade;
    private Constraint dropConstraint;

    AlterTableImpl(Configuration configuration, Table<?> table) {
        super(configuration);
        this.table = table;
    }

    @Override
    public final <T> AlterTableImpl add(Field<T> field, DataType<T> type) {
        return this.addColumn((Field)field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(String field, DataType<?> type) {
        return this.addColumn(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(String field, DataType<?> type) {
        return this.addColumn((Field)DSL.field(DSL.name(field), type), (DataType)type);
    }

    @Override
    public final <T> AlterTableImpl addColumn(Field<T> field, DataType<T> type) {
        this.addColumn = field;
        this.addColumnType = type;
        return this;
    }

    @Override
    public final AlterTableImpl add(Constraint constraint) {
        this.addConstraint = constraint;
        return this;
    }

    public final <T> AlterTableImpl alter(Field<T> field) {
        return this.alterColumn((Field)field);
    }

    public final AlterTableImpl alter(String field) {
        return this.alterColumn(field);
    }

    public final AlterTableImpl alterColumn(String field) {
        return this.alterColumn((Field)DSL.field(DSL.name(field)));
    }

    public final <T> AlterTableImpl alterColumn(Field<T> field) {
        this.alterColumn = field;
        return this;
    }

    public final AlterTableImpl set(DataType type) {
        this.alterColumnType = type;
        return this;
    }

    public final AlterTableImpl defaultValue(Object literal) {
        return this.defaultValue((Field)DSL.inline(literal));
    }

    public final AlterTableImpl defaultValue(Field expression) {
        this.alterColumnDefault = expression;
        return this;
    }

    @Override
    public final AlterTableImpl drop(Field<?> field) {
        return this.dropColumn((Field)field);
    }

    @Override
    public final AlterTableImpl drop(String field) {
        return this.dropColumn(field);
    }

    @Override
    public final AlterTableImpl dropColumn(String field) {
        return this.dropColumn((Field)DSL.field(DSL.name(field)));
    }

    @Override
    public final AlterTableImpl dropColumn(Field<?> field) {
        this.dropColumn = field;
        return this;
    }

    @Override
    public final AlterTableImpl drop(Constraint constraint) {
        this.dropConstraint = constraint;
        return this;
    }

    @Override
    public final AlterTableImpl dropConstraint(String constraint) {
        return this.drop(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableFinalStep cascade() {
        this.dropColumnCascade = true;
        return this;
    }

    @Override
    public final AlterTableFinalStep restrict() {
        this.dropColumnCascade = false;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        SQLDialect family = ctx.configuration().dialect().family();
        this.accept0(ctx);
    }

    private final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.configuration().dialect().family();
        ctx.start(Clause.ALTER_TABLE_TABLE).keyword("alter table").sql(' ').visit(this.table).end(Clause.ALTER_TABLE_TABLE);
        if (this.addColumn != null) {
            ctx.start(Clause.ALTER_TABLE_ADD).sql(' ').keyword("add").sql(' ');
            ctx.qualify(false).visit(this.addColumn).sql(' ').qualify(true);
            Utils.toSQLDDLTypeDeclaration(ctx, this.addColumnType);
            if (!this.addColumnType.nullable()) {
                ctx.sql(' ').keyword("not null");
            } else if (!Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)family)) {
                ctx.sql(' ').keyword("null");
            }
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.addConstraint != null) {
            ctx.start(Clause.ALTER_TABLE_ADD);
            ctx.sql(' ').keyword("add").sql(' ').visit(this.addConstraint);
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.alterColumn != null) {
            ctx.start(Clause.ALTER_TABLE_ALTER);
            switch (family) {
                case CUBRID: 
                case MARIADB: 
                case MYSQL: {
                    if (this.alterColumnDefault == null) {
                        ctx.sql(' ').keyword("change column").sql(' ').qualify(false).visit(this.alterColumn).qualify(true);
                        break;
                    }
                    ctx.sql(' ').keyword("alter column");
                    break;
                }
                default: {
                    ctx.sql(' ').keyword("alter");
                }
            }
            ctx.sql(' ').qualify(false).visit(this.alterColumn).qualify(true);
            if (this.alterColumnType != null) {
                switch (family) {
                    case DERBY: {
                        ctx.sql(' ').keyword("set data type");
                        break;
                    }
                    case POSTGRES: {
                        ctx.sql(' ').keyword("type");
                    }
                }
                ctx.sql(' ');
                Utils.toSQLDDLTypeDeclaration(ctx, this.alterColumnType);
                if (!this.alterColumnType.nullable()) {
                    ctx.sql(' ').keyword("not null");
                }
            } else if (this.alterColumnDefault != null) {
                ctx.start(Clause.ALTER_TABLE_ALTER_DEFAULT);
                switch (family) {
                    default: 
                }
                ctx.sql(' ').keyword("set default");
                ctx.sql(' ').visit(this.alterColumnDefault).end(Clause.ALTER_TABLE_ALTER_DEFAULT);
            }
            ctx.end(Clause.ALTER_TABLE_ALTER);
        } else if (this.dropColumn != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            switch (family) {
                default: 
            }
            ctx.sql(' ').keyword("drop");
            ctx.sql(' ').qualify(false).visit(this.dropColumn).qualify(true);
            switch (family) {
                default: 
            }
            if (this.dropColumnCascade) {
                ctx.sql(' ').keyword("cascade");
            }
            ctx.end(Clause.ALTER_TABLE_DROP);
        } else if (this.dropConstraint != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            ctx.data((Object)Utils.DataKey.DATA_DROP_CONSTRAINT, true);
            ctx.sql(' ').keyword("drop").sql(' ').visit(this.dropConstraint);
            ctx.data().remove((Object)Utils.DataKey.DATA_DROP_CONSTRAINT);
            ctx.end(Clause.ALTER_TABLE_DROP);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

