/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.velocity.render;

import java.io.IOException;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.servlet.ServletRequest;
import org.apache.tiles.request.servlet.ServletUtil;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.VelocityView;
import org.apache.velocity.tools.view.ViewToolContext;

public class VelocityRenderer
implements Renderer {
    private VelocityView velocityView;

    public VelocityRenderer(VelocityView velocityView) {
        this.velocityView = velocityView;
    }

    public void render(String path, Request request) throws IOException {
        if (path == null) {
            throw new CannotRenderException("Cannot dispatch a null path");
        }
        ServletRequest servletRequest = ServletUtil.getServletRequest((Request)request);
        ViewToolContext context = this.velocityView.createContext(servletRequest.getRequest(), servletRequest.getResponse());
        Template template = this.velocityView.getTemplate(path);
        this.velocityView.merge(template, (Context)context, request.getWriter());
    }

    public boolean isRenderable(String path, Request request) {
        return path != null && path.startsWith("/") && path.endsWith(".vm");
    }
}

