/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.validation.constraints.impl;

import blue.hive.validation.constraints.BHiveAllowExtensions;
import blue.hive.validation.constraints.impl.BHiveConstraintValidator;
import java.util.ArrayList;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class BHiveAllowExtensionsForMultipartFile
extends BHiveConstraintValidator<BHiveAllowExtensions, MultipartFile> {
    protected String allowExtensionsString = "";
    protected ArrayList<String> allowExtensions = new ArrayList();

    @Override
    public void initialize(BHiveAllowExtensions constraintAnnotation) {
        String[] extentions;
        this.allowExtensionsString = constraintAnnotation.value();
        for (String extention : extentions = StringUtils.tokenizeToStringArray((String)this.allowExtensionsString, (String)",")) {
            this.allowExtensions.add(extention.toLowerCase());
        }
    }

    @Override
    public boolean isValid(MultipartFile value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        String filename = value.getOriginalFilename();
        String extension = FilenameUtils.getExtension((String)filename).toLowerCase();
        boolean allowed = false;
        for (String allowExtension : this.allowExtensions) {
            if (!allowExtension.equalsIgnoreCase(extension)) continue;
            allowed = true;
            break;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("isValid({}) allowextension:{} => allowed: {}", new Object[]{filename, this.allowExtensionsString, allowed});
        }
        return allowed;
    }
}

