/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import org.slf4j.LoggerFactory;

public class BHiveLogUtil {
    public static List<Appender<ILoggingEvent>> getAppenders(boolean isStartedOnly) {
        ArrayList<Appender<ILoggingEvent>> appenders = new ArrayList<Appender<ILoggingEvent>>();
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger logger : context.getLoggerList()) {
            Iterator appenderIterator = logger.iteratorForAppenders();
            while (appenderIterator.hasNext()) {
                Appender appender = (Appender)appenderIterator.next();
                if (isStartedOnly && !appender.isStarted() || appenders.contains(appender)) continue;
                appenders.add((Appender<ILoggingEvent>)appender);
            }
        }
        return appenders;
    }

    public static List<Appender<ILoggingEvent>> getConsoleAppenders(boolean isStartedOnly) {
        ArrayList<Appender<ILoggingEvent>> appenders = new ArrayList<Appender<ILoggingEvent>>();
        List<Appender<ILoggingEvent>> allAppenders = BHiveLogUtil.getAppenders(isStartedOnly);
        for (Appender<ILoggingEvent> appender : allAppenders) {
            if (!(appender instanceof ConsoleAppender)) continue;
            appenders.add(appender);
        }
        return appenders;
    }

    public static void stopAllAppenders(List<Appender<ILoggingEvent>> appenders) {
        for (Appender<ILoggingEvent> appender : appenders) {
            if (!appender.isStarted()) continue;
            appender.stop();
        }
    }

    public static void startAllAppenders(List<Appender<ILoggingEvent>> appenders) {
        for (Appender<ILoggingEvent> appender : appenders) {
            if (appender.isStarted()) continue;
            appender.start();
        }
    }

    public static Map<String, String> getLoggableRequestMap(ServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map parameterMap = request.getParameterMap();
        for (Map.Entry item : parameterMap.entrySet()) {
            String key = (String)item.getKey();
            String[] value = (String[])item.getValue();
            result.put(key, Arrays.asList(value).toString());
        }
        return result;
    }

    public static boolean isGracefulException(Exception ex) {
        try {
            String text = ex.getMessage();
            String regex = "^\\x7B\\x22code\\x22:\\x22.*\\x22\\x2C\\x22msg\\x22:\\x22.*\\x22";
            Pattern pattern = Pattern.compile(regex, 2);
            Matcher matcher = pattern.matcher(text);
            boolean matched = matcher.find();
            return matched;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

