/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util;

import blue.hive.util.anyframe.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class BHiveHostingUtil {
    public static String getWasContainerName() {
        String name = System.getProperty("weblogic.Name");
        if (!StringUtil.isEmpty(name)) {
            return name;
        }
        return "";
    }

    public static boolean isProxyRequest(HttpServletRequest request) {
        String clientIP = request.getHeader("client-ip");
        String proxyClientIP = request.getHeader("Proxy-Client-IP");
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        return !StringUtil.isEmpty(clientIP) || !StringUtil.isEmpty(proxyClientIP) || !StringUtil.isEmpty(xForwardedFor);
    }

    public static boolean isLocalhostRequest(HttpServletRequest request) {
        String localAddr;
        String remoteAddr = request.getRemoteAddr();
        if (remoteAddr.equals(localAddr = request.getLocalAddr())) {
            return true;
        }
        return remoteAddr.equals("0:0:0:0:0:0:0:1");
    }

    public static String getClientIP(HttpServletRequest request) {
        String httpXForwardedFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (!StringUtil.isEmpty(httpXForwardedFor)) {
            String[] httpXForwardedForIPs = StringUtils.tokenizeToStringArray((String)httpXForwardedFor, (String)",");
            return httpXForwardedForIPs[0];
        }
        String xForwardedFor = request.getHeader("X-FORWARDED-FOR");
        if (!StringUtil.isEmpty(xForwardedFor)) {
            return xForwardedFor;
        }
        String clientIP = request.getHeader("client-ip");
        if (!StringUtil.isEmpty(clientIP)) {
            return clientIP;
        }
        String proxyClientIP = request.getHeader("Proxy-Client-IP");
        if (!StringUtil.isEmpty(proxyClientIP)) {
            return proxyClientIP;
        }
        return request.getRemoteAddr();
    }
}

