/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.http.converter;

import blue.hive.spring.http.converter.MultipartHttpOutputMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.mail.internet.MimeUtility;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class BHiveMapHttpMessageConverter
implements HttpMessageConverter<Map<String, ?>> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final byte[] BOUNDARY_CHARS = new byte[]{45, 95, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private Charset charset = DEFAULT_CHARSET;
    private Charset multipartCharset;
    private List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
    private List<HttpMessageConverter<?>> partConverters = new ArrayList();
    private final Random random = new Random();

    public BHiveMapHttpMessageConverter() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
        this.supportedMediaTypes.add(MediaType.MULTIPART_FORM_DATA);
        this.partConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.partConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        this.partConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setMultipartCharset(Charset multipartCharset) {
        this.multipartCharset = multipartCharset;
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        this.supportedMediaTypes = supportedMediaTypes;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.supportedMediaTypes);
    }

    public void setPartConverters(List<HttpMessageConverter<?>> partConverters) {
        Assert.notEmpty(partConverters, (String)"'partConverters' must not be empty");
        this.partConverters = partConverters;
    }

    public void addPartConverter(HttpMessageConverter<?> partConverter) {
        Assert.notNull(partConverter, (String)"'partConverter' must not be null");
        this.partConverters.add(partConverter);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!Map.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (supportedMediaType.equals((Object)MediaType.MULTIPART_FORM_DATA) || !supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        if (!Map.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null || MediaType.ALL.equals((Object)mediaType)) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> read(Class<? extends Map<String, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = contentType.getCharset() != null ? contentType.getCharset() : this.charset;
        String body = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)charset);
        String[] pairs = StringUtils.tokenizeToStringArray((String)body, (String)"&");
        HashMap<String, String> result = new HashMap<String, String>(pairs.length);
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.put(URLDecoder.decode(pair, charset.name()), null);
                continue;
            }
            String name = URLDecoder.decode(pair.substring(0, idx), charset.name());
            String value = URLDecoder.decode(pair.substring(idx + 1), charset.name());
            result.put(name, value);
        }
        return result;
    }

    public void write(Map<String, ?> map, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (!this.isMultipart(map, contentType)) {
            this.writeForm(map, contentType, outputMessage);
        } else {
            this.writeMultipart(map, outputMessage);
        }
    }

    private boolean isMultipart(Map<String, ?> map, MediaType contentType) {
        if (contentType != null) {
            return MediaType.MULTIPART_FORM_DATA.includes(contentType);
        }
        for (Map.Entry<String, ?> name : map.entrySet()) {
            Object value = name.getValue();
            if (value == null || value instanceof String) continue;
            return true;
        }
        return false;
    }

    private void writeForm(Map<String, String> form, MediaType contentType, HttpOutputMessage outputMessage) throws IOException {
        Charset charset;
        if (contentType != null) {
            outputMessage.getHeaders().setContentType(contentType);
            charset = contentType.getCharset() != null ? contentType.getCharset() : this.charset;
        } else {
            outputMessage.getHeaders().setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            charset = this.charset;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> nameIterator = form.entrySet().iterator();
        while (nameIterator.hasNext()) {
            Map.Entry<String, String> name = nameIterator.next();
            String value = name.getValue();
            builder.append(URLEncoder.encode(name.getValue(), charset.name()));
            if (value != null) {
                builder.append('=');
                builder.append(URLEncoder.encode(value, charset.name()));
            }
            if (!nameIterator.hasNext()) continue;
            builder.append('&');
        }
        byte[] bytes = builder.toString().getBytes(charset.name());
        outputMessage.getHeaders().setContentLength((long)bytes.length);
        StreamUtils.copy((byte[])bytes, (OutputStream)outputMessage.getBody());
    }

    private void writeMultipart(Map<String, Object> parts, HttpOutputMessage outputMessage) throws IOException {
        byte[] boundary = this.generateMultipartBoundary();
        Map<String, String> parameters = Collections.singletonMap("boundary", new String(boundary, "US-ASCII"));
        MediaType contentType = new MediaType(MediaType.MULTIPART_FORM_DATA, parameters);
        outputMessage.getHeaders().setContentType(contentType);
        this.writeParts(outputMessage.getBody(), parts, boundary);
        this.writeEnd(outputMessage.getBody(), boundary);
    }

    private void writeParts(OutputStream os, Map<String, Object> parts, byte[] boundary) throws IOException {
        for (Map.Entry<String, Object> entry : parts.entrySet()) {
            String name = entry.getKey();
            Object part = entry.getValue();
            if (part == null) continue;
            this.writeBoundary(os, boundary);
            this.writePart(name, this.getHttpEntity(part), os);
            this.writeNewLine(os);
        }
    }

    private void writePart(String name, HttpEntity<?> partEntity, OutputStream os) throws IOException {
        Object partBody = partEntity.getBody();
        Class<?> partType = partBody.getClass();
        HttpHeaders partHeaders = partEntity.getHeaders();
        MediaType partContentType = partHeaders.getContentType();
        for (HttpMessageConverter<?> messageConverter : this.partConverters) {
            if (!messageConverter.canWrite(partType, partContentType)) continue;
            MultipartHttpOutputMessage multipartMessage = new MultipartHttpOutputMessage(os);
            multipartMessage.getHeaders().setContentDispositionFormData(name, this.getFilename(partBody));
            if (!partHeaders.isEmpty()) {
                multipartMessage.getHeaders().putAll((Map)partHeaders);
            }
            messageConverter.write(partBody, partContentType, (HttpOutputMessage)multipartMessage);
            return;
        }
        throw new HttpMessageNotWritableException("Could not write request: no suitable HttpMessageConverter found for request type [" + partType.getName() + "]");
    }

    protected byte[] generateMultipartBoundary() {
        byte[] boundary = new byte[this.random.nextInt(11) + 30];
        for (int i = 0; i < boundary.length; ++i) {
            boundary[i] = BOUNDARY_CHARS[this.random.nextInt(BOUNDARY_CHARS.length)];
        }
        return boundary;
    }

    protected HttpEntity<?> getHttpEntity(Object part) {
        if (part instanceof HttpEntity) {
            return (HttpEntity)part;
        }
        return new HttpEntity(part);
    }

    protected String getFilename(Object part) {
        if (part instanceof Resource) {
            Resource resource = (Resource)part;
            String filename = resource.getFilename();
            if (this.multipartCharset != null) {
                filename = MimeDelegate.encode(filename, this.multipartCharset.name());
            }
            return filename;
        }
        return null;
    }

    private void writeBoundary(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        this.writeNewLine(os);
    }

    private void writeEnd(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        os.write(45);
        os.write(45);
        this.writeNewLine(os);
    }

    private void writeNewLine(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    private static class MimeDelegate {
        private MimeDelegate() {
        }

        public static String encode(String value, String charset) {
            try {
                return MimeUtility.encodeText((String)value, (String)charset, null);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

