/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.context;

import blue.hive.spring.context.ApplicationContextHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class BHiveApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger logger = LoggerFactory.getLogger(BHiveApplicationContextInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ApplicationContextHolder.setApplicationContext((ApplicationContext)applicationContext);
        logger.warn("\r\n##########################################\r\nApplication Starting...\r\nApplication Name: {}\r\n##########################################", (Object)applicationContext.getApplicationName());
        this.logSpringActiveProfile(applicationContext);
    }

    private void logSpringActiveProfile(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        ArrayList defaultProfiles = Lists.newArrayList((Object[])environment.getDefaultProfiles());
        ArrayList activeProfiles = Lists.newArrayList((Object[])environment.getActiveProfiles());
        logger.info("");
        logger.info("## StartUp");
        logger.info("## Init Application Context.....");
        logger.info("");
        logger.info("############################################################");
        logger.info(" DefaultProfiles: {}", (Object)defaultProfiles);
        logger.info(" ActiveProfiles: {}", (Object)activeProfiles);
        logger.info("############################################################");
        logger.info("");
    }
}

