/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.jackson.datatype.joda;

import blue.hive.util.BHiveDateUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.deser.LocalDateTimeDeserializer;
import java.io.IOException;
import org.joda.time.LocalDateTime;
import org.springframework.util.StringUtils;

public class BHiveLocalDateTimeDeserialiser
extends LocalDateTimeDeserializer {
    private static final long serialVersionUID = -565820334558847688L;

    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        try {
            switch (p.getCurrentTokenId()) {
                case 6: {
                    String str = StringUtils.trimWhitespace((String)p.getText());
                    if (str.length() == 0) {
                        return null;
                    }
                    LocalDateTime result = BHiveDateUtil.parseToLocalDateTime(str, false);
                    if (result == null) break;
                    return result;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.deserialize(p, ctxt);
    }
}

