/*
 * Decompiled with CFR 0.152.
 */
package com.dmallcott.dismissibleimageview;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.dmallcott.dismissibleimageview.DismissibleDragShadowBuilder;
import com.dmallcott.dismissibleimageview.DismissibleOnDragListener;
import com.dmallcott.dismissibleimageview.R;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;

public class FullScreenImageFragment
extends DialogFragment {
    private static final String ARGUMENT_BITMAP = "ARGUMENT_BITMAP";
    private static final String ARGUMENT_URL = "ARGUMENT_URL";
    private Bitmap bitmap;
    private ImageView imageView;
    private View topBorderView;
    private View bottomBorderView;
    private View leftBorderView;
    private View rightBorderView;

    protected static FullScreenImageFragment newInstance(@NonNull Bitmap bitmap) {
        FullScreenImageFragment fragment = new FullScreenImageFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable(ARGUMENT_BITMAP, (Parcelable)bitmap);
        fragment.setArguments(bundle);
        return fragment;
    }

    protected static FullScreenImageFragment newInstance(@NonNull String url) {
        FullScreenImageFragment fragment = new FullScreenImageFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARGUMENT_URL, url);
        fragment.setArguments(bundle);
        return fragment;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        LayoutInflater layoutInflater = (LayoutInflater)this.getActivity().getSystemService("layout_inflater");
        final View view = layoutInflater.inflate(R.layout.fragment_full_screen_image, null);
        try {
            dialog.getWindow().requestFeature(1);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (savedInstanceState != null) {
            this.bitmap = (Bitmap)savedInstanceState.getParcelable(ARGUMENT_BITMAP);
            this.initialiseViews(view, this.bitmap);
        } else if (this.getArguments().containsKey(ARGUMENT_BITMAP) && this.getArguments().getParcelable(ARGUMENT_BITMAP) != null) {
            this.bitmap = (Bitmap)this.getArguments().getParcelable(ARGUMENT_BITMAP);
            this.initialiseViews(view, this.bitmap);
        } else if (this.getArguments().containsKey(ARGUMENT_URL) && this.getArguments().getParcelable(ARGUMENT_URL) != null) {
            Picasso.with((Context)this.getContext()).load(this.getArguments().getString(ARGUMENT_URL)).into(new Target(){

                public void onBitmapLoaded(Bitmap bm, Picasso.LoadedFrom from) {
                    FullScreenImageFragment.this.bitmap = bm;
                    FullScreenImageFragment.this.initialiseViews(view, FullScreenImageFragment.this.bitmap);
                }

                public void onBitmapFailed(Drawable errorDrawable) {
                }

                public void onPrepareLoad(Drawable placeHolderDrawable) {
                }
            });
        }
        dialog.setContentView(view);
        return dialog;
    }

    public void onActivityCreated(Bundle arg0) {
        super.onActivityCreated(arg0);
        if (this.getDialog() != null) {
            this.getDialog().getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
        }
    }

    public void onStart() {
        super.onStart();
        if (this.getDialog() != null) {
            this.getDialog().getWindow().setLayout(-1, -1);
            this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(ARGUMENT_BITMAP, (Parcelable)Bitmap.createBitmap((Bitmap)this.bitmap));
    }

    private void initialiseViews(final @NonNull View view, @NonNull Bitmap bitmap) {
        this.imageView = (ImageView)view.findViewById(R.id.fragment_full_screen_imageView);
        this.topBorderView = view.findViewById(R.id.fragment_full_screen_top_border);
        this.bottomBorderView = view.findViewById(R.id.fragment_full_screen_bottom_border);
        this.leftBorderView = view.findViewById(R.id.fragment_full_screen_left_border);
        this.rightBorderView = view.findViewById(R.id.fragment_full_screen_right_border);
        this.leftBorderView.setOnDragListener((View.OnDragListener)new DismissibleOnDragListener(new DismissibleOnDragListener.OnDropListener(){

            @Override
            void onDragStarted() {
                FullScreenImageFragment.this.imageView.setVisibility(4);
            }

            @Override
            public void onDrop() {
                FullScreenImageFragment.this.dismiss();
            }

            @Override
            void onDragEnded() {
                FullScreenImageFragment.this.imageView.setVisibility(0);
                view.setAlpha(1.0f);
            }

            @Override
            void onDragLocation(float x, float y) {
                view.setAlpha(x / (float)FullScreenImageFragment.this.leftBorderView.getWidth());
            }
        }));
        this.rightBorderView.setOnDragListener((View.OnDragListener)new DismissibleOnDragListener(new DismissibleOnDragListener.OnDropListener(){

            @Override
            void onDragStarted() {
                FullScreenImageFragment.this.imageView.setVisibility(4);
            }

            @Override
            public void onDrop() {
                FullScreenImageFragment.this.dismiss();
            }

            @Override
            void onDragEnded() {
                FullScreenImageFragment.this.imageView.setVisibility(0);
                view.setAlpha(1.0f);
            }

            @Override
            void onDragLocation(float x, float y) {
                view.setAlpha(1.0f - x / (float)FullScreenImageFragment.this.rightBorderView.getWidth());
            }
        }));
        this.topBorderView.setOnDragListener((View.OnDragListener)new DismissibleOnDragListener(new DismissibleOnDragListener.OnDropListener(){

            @Override
            void onDragStarted() {
                FullScreenImageFragment.this.imageView.setVisibility(4);
            }

            @Override
            public void onDrop() {
                FullScreenImageFragment.this.dismiss();
            }

            @Override
            void onDragEnded() {
                FullScreenImageFragment.this.imageView.setVisibility(0);
                view.setAlpha(1.0f);
            }

            @Override
            void onDragLocation(float x, float y) {
                view.setAlpha(y / (float)FullScreenImageFragment.this.topBorderView.getHeight());
            }
        }));
        this.bottomBorderView.setOnDragListener((View.OnDragListener)new DismissibleOnDragListener(new DismissibleOnDragListener.OnDropListener(){

            @Override
            void onDragStarted() {
                FullScreenImageFragment.this.imageView.setVisibility(4);
            }

            @Override
            public void onDrop() {
                FullScreenImageFragment.this.dismiss();
            }

            @Override
            void onDragEnded() {
                FullScreenImageFragment.this.imageView.setVisibility(0);
                view.setAlpha(1.0f);
            }

            @Override
            void onDragLocation(float x, float y) {
                view.setAlpha(1.0f - y / (float)FullScreenImageFragment.this.topBorderView.getHeight());
            }
        }));
        this.imageView.setAdjustViewBounds(true);
        this.imageView.setImageBitmap(bitmap);
        this.imageView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        Point offset = new Point((int)event.getX(), (int)event.getY());
                        DismissibleDragShadowBuilder shadowBuilder = new DismissibleDragShadowBuilder(FullScreenImageFragment.this.imageView, offset);
                        FullScreenImageFragment.this.imageView.startDrag(null, (View.DragShadowBuilder)shadowBuilder, (Object)FullScreenImageFragment.this.imageView, 0);
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

