/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.fet;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.CallSuper;
import java.util.ArrayList;
import java.util.List;
import me.dkzwm.widget.fet.ClearEditText;
import me.dkzwm.widget.fet.R;

public class FormattedEditText
extends ClearEditText {
    public static final int MODE_NONE = -1;
    public static final int MODE_SIMPLE = 0;
    public static final int MODE_COMPLEX = 1;
    public static final int MODE_MASK = 2;
    public static final int MODE_HINT = 3;
    private static final Object SELECTION_SPAN = new Object();
    private static final InputFilter[] EMPTY_FILTERS = new InputFilter[0];
    private static final Spanned EMPTY_SPANNED = new SpannedString((CharSequence)"");
    private static final String DEFAULT_PLACE_HOLDER = " ";
    private static final String DEFAULT_MARK = "*";
    private static final int DIGIT_MASK_POINT = "0".codePointAt(0);
    private static final int LETTER_MASK_POINT = "A".codePointAt(0);
    private static final int DIGIT_OR_LETTER_MASK_POINT = "*".codePointAt(0);
    private static final int CHARACTER_MASK_POINT = "?".codePointAt(0);
    private static final int ESCAPE_MASK_POINT = "\\".codePointAt(0);
    private int mMode = -1;
    private String mPlaceholder;
    private String mEmptyPlaceholder;
    private String mMark;
    private String mHintText;
    private String mFormatStyle;
    private String mOriginalFormatStyle;
    private boolean mShowHintWhileEmpty = false;
    private int mHintColor = -1;
    private boolean mIsFormatted = false;
    private List<TextWatcher> mWatchers;
    private FormattedTextWatcher mTextWatcher;
    private LengthFilterDelegate mLengthFilterDelegate;
    private boolean mRestoring = false;
    private boolean mFilterRestoreTextChangeEvent = false;
    private SparseArray<Matcher> mMaskFilters;
    private SparseArray<PlaceholderConverter> mPlaceholderFilters;

    public FormattedEditText(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public FormattedEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public FormattedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mTextWatcher = new FormattedTextWatcher();
        super.addTextChangedListener((TextWatcher)this.mTextWatcher);
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FormattedEditText, defStyleAttr, 0);
            try {
                int mode = ta.getInt(R.styleable.FormattedEditText_fet_mode, -1);
                String mark = ta.getString(R.styleable.FormattedEditText_fet_mark);
                int hintColor = ta.getColor(R.styleable.FormattedEditText_fet_hintTextColor, -1);
                String placeHolder = ta.getString(R.styleable.FormattedEditText_fet_placeholder);
                String emptyPlaceHolder = ta.getString(R.styleable.FormattedEditText_fet_emptyPlaceholder);
                String formatStyle = ta.getString(R.styleable.FormattedEditText_fet_formatStyle);
                String hintText = ta.getString(R.styleable.FormattedEditText_fet_hintText);
                boolean showHintWhileEmpty = ta.getBoolean(R.styleable.FormattedEditText_fet_showHintWhileEmpty, false);
                this.setConfig(Config.create().mode(mode).placeholder(placeHolder == null || placeHolder.length() == 0 ? DEFAULT_PLACE_HOLDER : placeHolder).hintColor(hintColor).hintText(hintText).mark(mark == null || mark.length() == 0 ? DEFAULT_MARK : mark).emptyPlaceholder(emptyPlaceHolder == null || emptyPlaceHolder.length() == 0 ? null : emptyPlaceHolder).formatStyle(formatStyle).showHintWhileEmpty(showHintWhileEmpty), true);
            }
            finally {
                ta.recycle();
            }
        }
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mWatchers == null) {
            this.mWatchers = new ArrayList<TextWatcher>();
        }
        this.mWatchers.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        if (this.mWatchers != null) {
            this.mWatchers.remove(watcher);
        }
    }

    @CallSuper
    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException("filters can not be null");
        }
        for (int i = 0; i < filters.length; ++i) {
            if (!(filters[i] instanceof InputFilter.LengthFilter)) continue;
            this.mLengthFilterDelegate = new LengthFilterDelegate(filters[i]);
            filters[i] = this.mLengthFilterDelegate;
        }
        super.setFilters(filters);
    }

    public int getMode() {
        return this.mMode;
    }

    public String getFormatStyle() {
        return this.mFormatStyle;
    }

    public String getPlaceholder() {
        return this.mPlaceholder;
    }

    public String getEmptyPlaceholder() {
        return this.mEmptyPlaceholder;
    }

    public String getMark() {
        return this.mMark;
    }

    public String getHintText() {
        return this.mHintText;
    }

    public boolean isShowHintWhileEmpty() {
        return this.mShowHintWhileEmpty;
    }

    public int getHintColor() {
        return this.mHintColor;
    }

    private void setConfig(Config config, boolean create) {
        if (config.mMode != null) {
            this.mMode = config.mMode;
        }
        if (this.mMode == -1) {
            return;
        }
        if (config.mFormatStyle != null && config.mFormatStyle.length() > 0) {
            this.mOriginalFormatStyle = config.mFormatStyle;
            if (this.mMode == 0) {
                if (config.mPlaceholder != null) {
                    if (config.mPlaceholder.codePointCount(0, config.mPlaceholder.length()) > 1) {
                        throw new IllegalArgumentException("emptyPlaceholder must be null or length one character");
                    }
                    this.mPlaceholder = config.mPlaceholder;
                }
                this.parseSimpleFormatStyle();
            } else if (this.mMode == 1) {
                if (config.mMark != null) {
                    if (config.mMark.codePointCount(0, config.mMark.length()) > 1) {
                        throw new IllegalArgumentException("mark must be null or length one character");
                    }
                    this.mMark = config.mMark;
                }
                this.parseComplexFormatStyle();
            } else {
                this.mFormatStyle = this.mOriginalFormatStyle;
                if (this.mMode == 3) {
                    this.checkHintStyleIsRight(config.mHintText);
                }
            }
        } else if (this.mFormatStyle != null) {
            if (this.mMode == 0) {
                if (config.mPlaceholder != null && !this.mPlaceholder.equals(config.mPlaceholder)) {
                    if (config.mPlaceholder.codePointCount(0, config.mPlaceholder.length()) > 1) {
                        throw new IllegalArgumentException("emptyPlaceholder must be null or length one character");
                    }
                    this.mPlaceholder = config.mPlaceholder;
                    this.parseSimpleFormatStyle();
                }
            } else if (this.mMode == 1) {
                if (config.mMark != null && !this.mMark.equals(config.mMark)) {
                    if (config.mMark.codePointCount(0, config.mMark.length()) > 1) {
                        throw new IllegalArgumentException("mark must be null or length one character");
                    }
                    this.mMark = config.mMark;
                    this.parseComplexFormatStyle();
                }
            } else if (this.mMode == 3) {
                this.checkHintStyleIsRight(config.mHintText);
            }
        } else {
            throw new IllegalArgumentException("formatStyle can not be empty");
        }
        if (config.mShowHintWhileEmpty != null) {
            this.mShowHintWhileEmpty = config.mShowHintWhileEmpty;
        }
        if (config.mEmptyPlaceholder != null) {
            this.mEmptyPlaceholder = config.mEmptyPlaceholder;
        }
        if (config.mHintColor != null) {
            this.mHintColor = config.mHintColor;
        }
        if (config.mMaskFilters != null) {
            this.mMaskFilters = config.mMaskFilters;
        }
        if (config.mPlaceholderFilters != null) {
            this.mPlaceholderFilters = config.mPlaceholderFilters;
        }
        Editable text = this.getText();
        if (!create) {
            this.setText(this.getRealText());
            text = this.getText();
        } else {
            if (text == null) {
                this.setText("");
                return;
            }
            this.formatText(text, true);
        }
        if (text != null) {
            Selection.setSelection((Spannable)text, (int)text.length());
        }
    }

    private void parseSimpleFormatStyle() {
        int cc;
        int length = this.mOriginalFormatStyle.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; i += cc) {
            int cp = Character.codePointAt(this.mOriginalFormatStyle, i);
            if (!Character.isDigit(cp)) {
                throw new IllegalArgumentException("formatStyle must be numeric");
            }
            for (int count = Character.getNumericValue(cp); count > 0; --count) {
                builder.appendCodePoint(DIGIT_MASK_POINT);
            }
            cc = Character.charCount(cp);
            if (i + cc >= length) continue;
            builder.append(this.mPlaceholder);
        }
        this.mFormatStyle = builder.toString();
    }

    private void parseComplexFormatStyle() {
        int cp;
        if (!this.mOriginalFormatStyle.contains(this.mMark)) {
            throw new IllegalArgumentException("formatStyle must be have Mark strings");
        }
        int length = this.mOriginalFormatStyle.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; i += Character.charCount(cp)) {
            cp = Character.codePointAt(this.mOriginalFormatStyle, i);
            if (cp == this.mMark.codePointAt(0)) {
                builder.appendCodePoint(DIGIT_MASK_POINT);
                continue;
            }
            if (cp == DIGIT_OR_LETTER_MASK_POINT || cp == DIGIT_MASK_POINT || cp == LETTER_MASK_POINT || cp == ESCAPE_MASK_POINT) {
                builder.appendCodePoint(ESCAPE_MASK_POINT);
                builder.append(cp);
                continue;
            }
            builder.appendCodePoint(cp);
        }
        this.mFormatStyle = builder.toString();
    }

    public String getRealText() {
        return this.getRealText(false);
    }

    private String getRealText(boolean saved) {
        if (saved && this.mMode == -1) {
            return null;
        }
        Editable editable = this.getText();
        if (editable == null || editable.length() == 0) {
            return "";
        }
        SpannableStringBuilder value = new SpannableStringBuilder((CharSequence)editable);
        if (this.mMode == -1) {
            if (saved) {
                value.clear();
                return null;
            }
        } else {
            this.clearPlaceholders((Editable)value);
        }
        String realText = value.toString();
        value.clear();
        return realText;
    }

    private void clearPlaceholders(Editable value) {
        IPlaceholderSpan[] spans;
        for (IPlaceholderSpan span : spans = (IPlaceholderSpan[])value.getSpans(0, value.length(), IPlaceholderSpan.class)) {
            value.delete(value.getSpanStart((Object)span), value.getSpanEnd((Object)span));
        }
    }

    private void checkHintStyleIsRight(String hintText) {
        if (hintText != null) {
            this.mHintText = hintText;
            int indexInStyle = 0;
            int indexInText = 0;
            boolean nextCharIsText = false;
            while (indexInStyle < this.mFormatStyle.length()) {
                if (indexInText >= this.mHintText.length()) {
                    throw new IllegalArgumentException("hintText style must be conform to formatting style");
                }
                int charInStyle = this.mFormatStyle.codePointAt(indexInStyle);
                int charInText = this.mHintText.codePointAt(indexInText);
                if (!nextCharIsText && this.isMaskChar(charInStyle)) {
                    if (this.isMismatchMask(this.mHintText, indexInText, charInStyle, charInText)) {
                        throw new IllegalArgumentException("hintText style must be conform to formatting style");
                    }
                    indexInText += Character.charCount(charInText);
                    indexInStyle += Character.charCount(indexInStyle);
                    continue;
                }
                if (!nextCharIsText && charInStyle == ESCAPE_MASK_POINT) {
                    nextCharIsText = true;
                    indexInStyle += Character.charCount(ESCAPE_MASK_POINT);
                    continue;
                }
                if (charInStyle != charInText) {
                    throw new IllegalArgumentException("hintText style must be conform to formatting style");
                }
                nextCharIsText = false;
                ++indexInText;
                ++indexInStyle;
            }
            if (this.mHintText.length() != indexInText) {
                throw new IllegalArgumentException("hintText style must be conform to formatting style");
            }
        }
    }

    private void sendBeforeTextChanged(CharSequence s, int start, int count, int after) {
        List<TextWatcher> list = this.mWatchers;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).beforeTextChanged(s, start, count, after);
            }
        }
    }

    private void sendOnTextChanged(CharSequence s, int start, int before, int count) {
        List<TextWatcher> list = this.mWatchers;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).onTextChanged(s, start, before, count);
            }
        }
    }

    private void sendAfterTextChanged(Editable s) {
        List<TextWatcher> list = this.mWatchers;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).afterTextChanged(s);
            }
        }
    }

    private void formatText(Editable editable, boolean append) {
        int selectionEnd;
        int selectionStart;
        this.mIsFormatted = true;
        boolean filter = this.mFilterRestoreTextChangeEvent;
        super.removeTextChangedListener((TextWatcher)this.mTextWatcher);
        InputFilter[] filters = editable.getFilters();
        editable.setFilters(EMPTY_FILTERS);
        if (!filter) {
            selectionStart = Selection.getSelectionStart((CharSequence)editable);
            selectionEnd = Selection.getSelectionEnd((CharSequence)editable);
            editable.setSpan(SELECTION_SPAN, selectionStart, selectionEnd, 17);
        }
        this.formatMask(editable);
        if (!filter) {
            CharSequence out;
            selectionStart = editable.getSpanStart(SELECTION_SPAN);
            selectionEnd = editable.getSpanEnd(SELECTION_SPAN);
            editable.removeSpan(SELECTION_SPAN);
            editable.setFilters(filters);
            if (append && this.mLengthFilterDelegate != null && (out = this.mLengthFilterDelegate.mFilter.filter((CharSequence)editable, 0, editable.length(), EMPTY_SPANNED, 0, 0)) != null) {
                editable.delete(out.length(), editable.length());
            }
            Selection.setSelection((Spannable)editable, (int)Math.min(selectionStart, editable.length()), (int)Math.min(selectionEnd, editable.length()));
        } else {
            editable.setFilters(filters);
        }
        this.mIsFormatted = false;
        super.addTextChangedListener((TextWatcher)this.mTextWatcher);
    }

    private void formatMask(Editable editable) {
        this.clearPlaceholders(editable);
        if (editable.length() == 0 && this.isNeedClearText()) {
            return;
        }
        int indexInStyle = 0;
        int indexInText = 0;
        boolean nextCharIsText = false;
        int indexOfLastLiteral = 0;
        int indexOfEmptyOrHintStart = 0;
        boolean havingEmptyOrHint = false;
        while (indexInStyle < this.mFormatStyle.length()) {
            PlaceholderConverter converter;
            int charCount;
            int charInStyle = this.mFormatStyle.codePointAt(indexInStyle);
            int charInStyleCount = Character.charCount(charInStyle);
            if (!nextCharIsText && this.isMaskChar(charInStyle)) {
                int charInText;
                if (indexInText >= editable.length()) {
                    if (this.mMode == 2) {
                        if (this.mEmptyPlaceholder == null) break;
                        if (!havingEmptyOrHint) {
                            indexOfEmptyOrHintStart = indexInText;
                        }
                        editable.insert(indexInText, (CharSequence)this.mEmptyPlaceholder);
                        editable.setSpan((Object)new EmptyPlaceholderSpan(), indexInText, indexInText + this.mEmptyPlaceholder.length(), 33);
                        indexInText += this.mEmptyPlaceholder.length();
                        indexInStyle += charInStyleCount;
                        havingEmptyOrHint = true;
                        continue;
                    }
                    if (this.mHintText == null) break;
                    if (!havingEmptyOrHint) {
                        indexOfEmptyOrHintStart = indexInText;
                    }
                    charInText = this.mHintText.codePointAt(indexInText);
                    charCount = Character.charCount(charInText);
                    editable.insert(indexInText, this.mHintText.subSequence(indexInText, indexInText + charCount));
                    editable.setSpan((Object)new HintPlaceholderSpan(this.mHintColor == -1 ? this.getCurrentHintTextColor() : this.mHintColor), indexInText, indexInText + charCount, 33);
                    indexInText += charCount;
                    indexInStyle += Character.charCount(charInStyle);
                    havingEmptyOrHint = true;
                    continue;
                }
                charInText = Character.codePointAt((CharSequence)editable, indexInText);
                charCount = Character.charCount(charInText);
                if (this.isMismatchMask((CharSequence)editable, indexInText, charInStyle, charInText)) {
                    editable.delete(indexInText, indexInText + charCount);
                    continue;
                }
                indexInStyle += Character.charCount(charInStyle);
                indexOfLastLiteral = indexInText += charCount;
                continue;
            }
            if (!nextCharIsText && charInStyle == ESCAPE_MASK_POINT) {
                nextCharIsText = true;
                indexInStyle += Character.charCount(ESCAPE_MASK_POINT);
                continue;
            }
            String cur = new StringBuilder().appendCodePoint(charInStyle).toString();
            if (this.mPlaceholderFilters != null && (converter = (PlaceholderConverter)this.mPlaceholderFilters.get(charInStyle)) != null) {
                char[] chars = new char[indexInText];
                editable.getChars(0, indexInText, chars, 0);
                String textInStyle = converter.convert(String.valueOf(chars), cur);
                if (textInStyle == null || textInStyle.codePointCount(0, textInStyle.length()) != 1) {
                    throw new IllegalArgumentException("the converted must be length one character");
                }
                cur = textInStyle;
            }
            charCount = cur.length();
            editable.insert(indexInText, (CharSequence)cur);
            editable.setSpan((Object)new PlaceholderSpan(), indexInText, indexInText + charCount, 33);
            nextCharIsText = false;
            indexInText += charCount;
            indexInStyle += charCount;
        }
        if (!havingEmptyOrHint && indexOfLastLiteral != editable.length()) {
            editable.delete(indexOfLastLiteral, editable.length());
        } else if (havingEmptyOrHint && indexOfEmptyOrHintStart != 0 && editable.getSpanStart(SELECTION_SPAN) == 0) {
            editable.removeSpan(SELECTION_SPAN);
            editable.setSpan(SELECTION_SPAN, indexOfEmptyOrHintStart, indexOfEmptyOrHintStart, 17);
        }
    }

    private boolean isNeedClearText() {
        return this.mMode == 2 && (this.mShowHintWhileEmpty || this.mEmptyPlaceholder == null) || this.mMode == 3 && (this.mShowHintWhileEmpty || this.mHintText == null);
    }

    private boolean isMismatchMask(CharSequence sequence, int end, int mask, int value) {
        if (this.mMaskFilters != null) {
            Matcher matcher = (Matcher)this.mMaskFilters.get(mask);
            if (matcher != null) {
                String pre;
                if (sequence instanceof Editable) {
                    char[] chars = new char[end];
                    ((Editable)sequence).getChars(0, end, chars, 0);
                    pre = String.valueOf(chars);
                } else {
                    pre = sequence.subSequence(0, end).toString();
                }
                String cur = new StringBuilder().appendCodePoint(value).toString();
                return !matcher.hasMatch(pre, cur);
            }
            return false;
        }
        return !(mask == CHARACTER_MASK_POINT || mask == LETTER_MASK_POINT && Character.isLetter(value) || mask == DIGIT_MASK_POINT && Character.isDigit(value) || mask == DIGIT_OR_LETTER_MASK_POINT && (Character.isDigit(value) || Character.isLetter(value)));
    }

    private boolean isMaskChar(int mask) {
        if (this.mMaskFilters != null) {
            return this.mMaskFilters.indexOfKey(mask) >= 0;
        }
        return mask == DIGIT_MASK_POINT || mask == LETTER_MASK_POINT || mask == DIGIT_OR_LETTER_MASK_POINT || mask == CHARACTER_MASK_POINT;
    }

    public Parcelable onSaveInstanceState() {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.mMode = this.mMode;
        savedState.mPlaceholder = this.mPlaceholder;
        savedState.mEmptyPlaceholder = this.mEmptyPlaceholder;
        savedState.mMark = this.mMark;
        savedState.mHintText = this.mHintText;
        savedState.mFormatStyle = this.mFormatStyle;
        savedState.mShowHintWhileEmpty = this.mShowHintWhileEmpty;
        savedState.mHintColor = this.mHintColor;
        savedState.mSelectionStart = start;
        savedState.mSelectionEnd = end;
        savedState.mRealText = this.getRealText(true);
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        this.mMode = savedState.mMode;
        this.mPlaceholder = savedState.mPlaceholder;
        this.mEmptyPlaceholder = savedState.mEmptyPlaceholder;
        this.mMark = savedState.mMark;
        this.mHintText = savedState.mHintText;
        this.mFormatStyle = savedState.mFormatStyle;
        this.mOriginalFormatStyle = savedState.mOriginalFormatStyle;
        this.mShowHintWhileEmpty = savedState.mShowHintWhileEmpty;
        this.mHintColor = savedState.mHintColor;
        if (savedState.mRealText != null) {
            this.mRestoring = true;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.mRestoring = false;
            this.mFilterRestoreTextChangeEvent = true;
            this.setText(savedState.mRealText);
            this.mFilterRestoreTextChangeEvent = false;
            Editable text = this.getText();
            Selection.setSelection((Spannable)text, (int)Math.min(savedState.mSelectionStart, text.length()), (int)Math.min(savedState.mSelectionEnd, text.length()));
        } else {
            super.onRestoreInstanceState(savedState.getSuperState());
        }
    }

    private class FormattedTextWatcher
    implements TextWatcher {
        private FormattedTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            if (FormattedEditText.this.mRestoring) {
                return;
            }
            FormattedEditText.this.sendBeforeTextChanged(s, start, count, after);
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (FormattedEditText.this.mRestoring) {
                return;
            }
            FormattedEditText.this.sendOnTextChanged(s, start, before, count);
            if (FormattedEditText.this.mMode == -1) {
                return;
            }
            if (!FormattedEditText.this.mIsFormatted && s instanceof Editable) {
                FormattedEditText.this.formatText((Editable)s, count != 0);
            }
        }

        public void afterTextChanged(Editable s) {
            if (FormattedEditText.this.mRestoring) {
                return;
            }
            FormattedEditText.this.sendAfterTextChanged(s);
        }
    }

    private class LengthFilterDelegate
    implements InputFilter {
        private final InputFilter mFilter;

        private LengthFilterDelegate(InputFilter filter) {
            this.mFilter = filter;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (FormattedEditText.this.mRestoring) {
                return null;
            }
            if (!FormattedEditText.this.mIsFormatted && FormattedEditText.this.mMode >= 2) {
                IEmptyPlaceholderSpan[] spans = (IEmptyPlaceholderSpan[])dest.getSpans(0, dest.length(), IEmptyPlaceholderSpan.class);
                if (spans.length == 0) {
                    return this.mFilter.filter(source, start, end, dest, dstart, dend);
                }
                return null;
            }
            return this.mFilter.filter(source, start, end, dest, dstart, dend);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        private int mMode = -1;
        private String mPlaceholder;
        private String mEmptyPlaceholder;
        private String mMark;
        private String mHintText;
        private String mFormatStyle;
        private String mOriginalFormatStyle;
        private String mRealText;
        private boolean mShowHintWhileEmpty = false;
        private int mHintColor = -1;
        private int mSelectionStart;
        private int mSelectionEnd;

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mMode = in.readInt();
            this.mPlaceholder = in.readString();
            this.mEmptyPlaceholder = in.readString();
            this.mMark = in.readString();
            this.mRealText = in.readString();
            this.mHintText = in.readString();
            this.mFormatStyle = in.readString();
            this.mOriginalFormatStyle = in.readString();
            this.mShowHintWhileEmpty = in.readInt() != 0;
            this.mHintColor = in.readInt();
            this.mSelectionStart = in.readInt();
            this.mSelectionEnd = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mMode);
            out.writeString(this.mPlaceholder);
            out.writeString(this.mEmptyPlaceholder);
            out.writeString(this.mMark);
            out.writeString(this.mRealText);
            out.writeString(this.mHintText);
            out.writeString(this.mFormatStyle);
            out.writeString(this.mOriginalFormatStyle);
            out.writeInt(this.mShowHintWhileEmpty ? 1 : 0);
            out.writeInt(this.mHintColor);
            out.writeInt(this.mSelectionStart);
            out.writeInt(this.mSelectionEnd);
        }
    }

    public static class Config {
        private Integer mMode;
        private Integer mHintColor;
        private String mMark;
        private String mPlaceholder;
        private String mEmptyPlaceholder;
        private Boolean mShowHintWhileEmpty;
        private String mHintText;
        private String mFormatStyle;
        private SparseArray<Matcher> mMaskFilters;
        private SparseArray<PlaceholderConverter> mPlaceholderFilters;

        private Config() {
        }

        public static Config create() {
            return new Config();
        }

        public Config mode(int mode) {
            this.mMode = mode;
            return this;
        }

        public Config hintText(String hintText) {
            this.mHintText = hintText;
            return this;
        }

        public Config mark(String mark) {
            this.mMark = mark;
            return this;
        }

        public Config placeholder(String placeholder) {
            this.mPlaceholder = placeholder;
            return this;
        }

        public Config showHintWhileEmpty(boolean showHintWhileEmpty) {
            this.mShowHintWhileEmpty = showHintWhileEmpty;
            return this;
        }

        public Config formatStyle(String formatStyle) {
            this.mFormatStyle = formatStyle;
            return this;
        }

        public Config hintColor(int hintColor) {
            this.mHintColor = hintColor;
            return this;
        }

        public Config emptyPlaceholder(String emptyPlaceholder) {
            this.mEmptyPlaceholder = emptyPlaceholder;
            return this;
        }

        public Config maskFilter(String mark, Matcher matcher) {
            if (mark.codePointCount(0, mark.length()) > 1) {
                throw new IllegalArgumentException("mark must be length one character");
            }
            if (this.mMaskFilters == null) {
                this.mMaskFilters = new SparseArray();
            }
            this.mMaskFilters.put(mark.codePointAt(0), (Object)matcher);
            return this;
        }

        public Config placeholderFilter(String mark, PlaceholderConverter converter) {
            if (mark.codePointCount(0, mark.length()) > 1) {
                throw new IllegalArgumentException("mark must be length one character");
            }
            if (this.mPlaceholderFilters == null) {
                this.mPlaceholderFilters = new SparseArray();
            }
            this.mPlaceholderFilters.put(mark.codePointAt(0), (Object)converter);
            return this;
        }

        public void config(FormattedEditText editText) {
            editText.setConfig(this, false);
        }
    }

    private static class HintPlaceholderSpan
    extends ForegroundColorSpan
    implements IEmptyPlaceholderSpan {
        HintPlaceholderSpan(int color) {
            super(color);
        }
    }

    private static class EmptyPlaceholderSpan
    implements IEmptyPlaceholderSpan {
        private EmptyPlaceholderSpan() {
        }
    }

    private static class PlaceholderSpan
    implements IPlaceholderSpan {
        private PlaceholderSpan() {
        }
    }

    private static interface IEmptyPlaceholderSpan
    extends IPlaceholderSpan {
    }

    private static interface IPlaceholderSpan {
    }

    public static interface PlaceholderConverter {
        public String convert(String var1, String var2);
    }

    public static interface Matcher {
        public boolean hasMatch(String var1, String var2);
    }
}

