/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.fet;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.appcompat.widget.AppCompatEditText;
import me.dkzwm.widget.fet.R;

public class ClearEditText
extends AppCompatEditText {
    public static final int GRAVITY_TOP = 0;
    public static final int GRAVITY_CENTER = 1;
    public static final int GRAVITY_BOTTOM = 2;
    private int mTouchSlop;
    private Drawable mClearDrawable;
    private int mGravity = 1;
    private int mRealPaddingRight;
    private int mDrawablePadding = 0;
    private float[] mDownPoint = new float[2];
    private OnClearClickListener mClearClickListener;

    public ClearEditText(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public ClearEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public ClearEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClearEditText, defStyleAttr, 0);
            try {
                this.mClearDrawable = ta.getDrawable(R.styleable.ClearEditText_fet_clearDrawable);
                this.mGravity = ta.getInt(R.styleable.ClearEditText_fet_drawableGravity, 1);
                this.mDrawablePadding = ta.getDimensionPixelSize(R.styleable.ClearEditText_fet_drawablePadding, 0);
            }
            finally {
                ta.recycle();
            }
        }
        this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        if (Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1) {
            throw new UnsupportedOperationException("We can not support this feature when the layout is right-to-left");
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.resetClearDrawableBound();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mClearDrawable != null) {
            int specSize;
            int specMode;
            int width = this.mClearDrawable.getIntrinsicWidth() + this.mDrawablePadding * 2;
            int height = this.mClearDrawable.getIntrinsicHeight() + this.mDrawablePadding * 2;
            int measuredWidth = this.getMeasuredWidth();
            int measuredHeight = this.getMeasuredHeight();
            int remeasuredWidth = measuredWidth;
            int remeasuredHeight = measuredHeight;
            if (measuredWidth < width) {
                specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                specSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                if (specMode != 0x40000000) {
                    remeasuredWidth = Math.max(width, measuredWidth);
                    if (specMode == Integer.MIN_VALUE) {
                        remeasuredWidth = Math.min(remeasuredWidth, specSize);
                    }
                }
            }
            if (measuredHeight < height) {
                specMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                specSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                if (specMode != 0x40000000) {
                    remeasuredHeight = Math.max(height, measuredHeight);
                    if (specMode == Integer.MIN_VALUE) {
                        remeasuredHeight = Math.min(remeasuredHeight, specSize);
                    }
                }
            }
            if (remeasuredWidth != measuredWidth || remeasuredHeight != measuredHeight) {
                this.setMeasuredDimension(remeasuredWidth, remeasuredHeight);
            }
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mRealPaddingRight = right;
        if (this.mClearDrawable != null) {
            right += this.mClearDrawable.getIntrinsicWidth() + this.mDrawablePadding * 2;
        }
        super.setPadding(left, top, right, bottom);
        this.resetClearDrawableBound();
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        this.mRealPaddingRight = end;
        if (this.mClearDrawable != null) {
            end += this.mClearDrawable.getIntrinsicWidth() + this.mDrawablePadding * 2;
        }
        super.setPaddingRelative(start, top, end, bottom);
        this.resetClearDrawableBound();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mClearDrawable != null && this.isFocused() && this.length() > 0) {
            canvas.save();
            canvas.translate((float)this.getScrollX(), (float)this.getScrollY());
            this.mClearDrawable.draw(canvas);
            canvas.restore();
        }
    }

    protected void drawableStateChanged() {
        if (this.mClearDrawable != null) {
            int[] state = this.getDrawableState();
            if (this.mClearDrawable.isStateful() && this.mClearDrawable.setState(state)) {
                Rect dirty = this.mClearDrawable.getBounds();
                int scrollX = this.getScrollX();
                int scrollY = this.getScrollY();
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            }
        }
        super.drawableStateChanged();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mClearDrawable != null) {
            float x = event.getX();
            float y = event.getY();
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    this.mDownPoint[0] = x;
                    this.mDownPoint[1] = y;
                    break;
                }
                case 1: {
                    Rect rect = this.mClearDrawable.getBounds();
                    if (!((float)(rect.top - this.mDrawablePadding) <= y) || !((float)(rect.bottom + this.mDrawablePadding) >= y) || !((float)(rect.left - this.mDrawablePadding) <= x) || !((float)(rect.right + this.mDrawablePadding) >= x) || !(Math.abs(this.mDownPoint[0] - x) <= (float)this.mTouchSlop) || !(Math.abs(this.mDownPoint[1] - y) <= (float)this.mTouchSlop)) break;
                    if (this.mClearClickListener != null) {
                        if (!this.mClearClickListener.onClearClick(this, this.mClearDrawable)) {
                            this.clearTextInTouch(event);
                        }
                    } else {
                        this.clearTextInTouch(event);
                    }
                    super.onTouchEvent(event);
                    return true;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public void setClearDrawable(Drawable drawable) {
        if (this.mClearDrawable != drawable) {
            this.mClearDrawable = drawable;
            this.requestLayout();
        }
    }

    public void setClearDrawablePadding(int pad) {
        if (this.mDrawablePadding != pad) {
            this.mDrawablePadding = pad;
            if (this.mClearDrawable != null) {
                this.requestLayout();
            }
        }
    }

    public void setOnClearClickListener(OnClearClickListener clickListener) {
        this.mClearClickListener = clickListener;
    }

    private void clearTextInTouch(MotionEvent event) {
        event.setAction(3);
        Editable editable = this.getText();
        if (editable != null) {
            editable.clear();
        }
    }

    private void resetClearDrawableBound() {
        if (this.mClearDrawable != null) {
            int top = this.getPaddingTop() + this.mDrawablePadding;
            int bottom = this.getPaddingBottom() + this.mDrawablePadding;
            int width = this.mClearDrawable.getIntrinsicWidth();
            int height = this.mClearDrawable.getIntrinsicHeight();
            int newRight = this.getWidth() - this.mRealPaddingRight - this.mDrawablePadding;
            int h = this.getHeight();
            switch (this.mGravity) {
                case 0: {
                    this.mClearDrawable.setBounds(newRight - width, top, newRight, top + height);
                    break;
                }
                case 1: {
                    int newTop = top + (h - top - bottom - height) / 2;
                    this.mClearDrawable.setBounds(newRight - width, newTop, newRight, newTop + height);
                    break;
                }
                default: {
                    int newBottom = h - bottom;
                    this.mClearDrawable.setBounds(newRight - width, newBottom - height, newRight, newBottom);
                }
            }
        }
    }

    public static interface OnClearClickListener {
        public boolean onClearClick(ClearEditText var1, Drawable var2);
    }
}

