/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.fet;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import java.util.ArrayList;
import java.util.List;
import me.dkzwm.widget.fet.R;

public class FormattedEditText
extends EditText {
    private static final char DEFAULT_PLACE_HOLDER = ' ';
    private char mPlaceHolder;
    private int[] mPlaceHoldersPos;
    private List<TextWatcher> mWatchers;
    private boolean mHasBeenFormatted = false;
    private StringBuilder mTextBuilder = new StringBuilder();

    public FormattedEditText(Context context) {
        this(context, null, 16842862);
    }

    public FormattedEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public FormattedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TextWatcher textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (!FormattedEditText.this.mHasBeenFormatted && (FormattedEditText.this.mPlaceHoldersPos == null || s.length() > 0 && s.length() - count == 0)) {
                    FormattedEditText.this.sendBeforeTextChanged(s, start, count, after);
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (FormattedEditText.this.mPlaceHoldersPos == null || s.length() == 0) {
                    FormattedEditText.this.sendOnTextChanged(s, start, before, count);
                    return;
                }
                if (!FormattedEditText.this.mHasBeenFormatted) {
                    FormattedEditText.this.formatText(s, start, before, count);
                }
            }

            public void afterTextChanged(Editable s) {
                if (FormattedEditText.this.mPlaceHoldersPos == null || s.length() == 0) {
                    FormattedEditText.this.sendAfterTextChanged(s);
                }
                if (s.length() == 0 && FormattedEditText.this.mTextBuilder.length() != 0) {
                    FormattedEditText.this.mTextBuilder.setLength(0);
                }
            }
        };
        super.addTextChangedListener(textWatcher);
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FormattedEditText, defStyleAttr, 0);
            String formatStyle = ta.getString(R.styleable.FormattedEditText_formatStyle);
            this.setFormatStyle(formatStyle);
            String placeHolder = ta.getString(R.styleable.FormattedEditText_placeHolder);
            if (placeHolder != null) {
                this.setPlaceHolder(placeHolder.charAt(0));
            } else {
                this.mPlaceHolder = (char)32;
            }
            ta.recycle();
        } else {
            this.mPlaceHolder = (char)32;
        }
        if (this.getText().length() > 0) {
            this.formatText(this.getText().toString(), 0, 0, this.getText().length());
        }
    }

    private static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mWatchers == null) {
            this.mWatchers = new ArrayList<TextWatcher>();
        }
        this.mWatchers.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        int i;
        if (this.mWatchers != null && (i = this.mWatchers.indexOf(watcher)) >= 0) {
            this.mWatchers.remove(i);
        }
    }

    public void setFormatStyle(String style) {
        if (style != null) {
            boolean isNumeric = FormattedEditText.isNumeric(style);
            if (isNumeric) {
                this.mPlaceHoldersPos = new int[style.length()];
                this.mPlaceHoldersPos[0] = Character.getNumericValue(style.charAt(0));
                for (int i = 1; i < style.length(); ++i) {
                    int number = Character.getNumericValue(style.charAt(i));
                    this.mPlaceHoldersPos[i] = this.mPlaceHoldersPos[i - 1] + 1 + number;
                }
            } else {
                throw new IllegalArgumentException("Format style must be numeric");
            }
        }
    }

    public void setPlaceHolder(char holder) {
        this.mPlaceHolder = holder;
    }

    private void sendBeforeTextChanged(CharSequence s, int start, int count, int after) {
        if (this.mWatchers != null) {
            List<TextWatcher> list = this.mWatchers;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).beforeTextChanged(s, start, count, after);
            }
        }
    }

    private void sendOnTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mWatchers != null) {
            List<TextWatcher> list = this.mWatchers;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).onTextChanged(s, start, before, count);
            }
        }
    }

    private void sendAfterTextChanged(Editable s) {
        if (this.mWatchers != null) {
            List<TextWatcher> list = this.mWatchers;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).afterTextChanged(s);
            }
        }
    }

    private void formatText(CharSequence s, int start, int before, int count) {
        int lastLength = this.mTextBuilder.length();
        String originText = this.mTextBuilder.toString();
        this.mTextBuilder.setLength(0);
        int nowPosition = 0;
        int realCount = 0;
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                for (int j = nowPosition; j < this.mPlaceHoldersPos.length && this.mPlaceHoldersPos[j] <= start + realCount; ++j) {
                    if (this.mPlaceHoldersPos[j] != start + realCount) continue;
                    ++realCount;
                    ++nowPosition;
                }
                if (s.charAt(start + i) == this.mPlaceHolder) continue;
                ++realCount;
            }
        }
        nowPosition = 0;
        int originLength = s.length();
        for (int i = 0; i < originLength; ++i) {
            if (s.charAt(i) == this.mPlaceHolder) continue;
            if (nowPosition >= this.mPlaceHoldersPos.length) {
                this.mTextBuilder.append(s.charAt(i));
                continue;
            }
            if (this.mTextBuilder.length() < this.mPlaceHoldersPos[nowPosition]) {
                this.mTextBuilder.append(s.charAt(i));
                continue;
            }
            if (this.mTextBuilder.length() == this.mPlaceHoldersPos[nowPosition]) {
                this.mTextBuilder.append(this.mPlaceHolder);
                this.mTextBuilder.append(s.charAt(i));
                ++nowPosition;
                continue;
            }
            this.mTextBuilder.append(s.charAt(i));
            ++nowPosition;
        }
        this.mHasBeenFormatted = true;
        String text = this.mTextBuilder.toString();
        if (before > 0) {
            this.sendBeforeTextChanged(originText, start, before, 0);
            this.setText(text);
            this.mHasBeenFormatted = false;
            if (start > text.length()) {
                this.setSelection(text.length());
                this.sendOnTextChanged(text, start, lastLength - text.length(), 0);
            } else {
                this.setSelection(start);
                this.sendOnTextChanged(text, start, before, 0);
            }
            this.sendAfterTextChanged(this.getText());
        } else {
            this.sendBeforeTextChanged(originText, start, 0, realCount);
            this.setText(text);
            this.mHasBeenFormatted = false;
            this.setSelection(start + realCount);
            this.sendOnTextChanged(text, start, before, realCount);
            this.sendAfterTextChanged(this.getText());
        }
    }
}

