/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.content.Context;
import in.co.dipankar.quickandorid.utils.DLog;

public class SharedPrefsUtil {
    private static SharedPrefsUtil instance;
    private static final String PREFS_NAME = "default_preferences";
    private Context mContext;

    public static synchronized SharedPrefsUtil getInstance() {
        if (instance == null) {
            instance = new SharedPrefsUtil();
        }
        return instance;
    }

    public void init(Context context) {
        this.mContext = context;
    }

    private SharedPrefsUtil() {
    }

    public String getString(String key, String defl) {
        if (this.mContext != null) {
            return this.mContext.getSharedPreferences(PREFS_NAME, 0).getString(key, defl);
        }
        DLog.e("SharedPrefsUtil is not yet initialized");
        return "";
    }

    public void setString(String key, String val) {
        this.mContext.getSharedPreferences(PREFS_NAME, 0).edit().putString(key, val).apply();
    }

    public Boolean getBoolean(String key, Boolean defl) {
        if (this.mContext != null) {
            return this.mContext.getSharedPreferences(PREFS_NAME, 0).getBoolean(key, defl.booleanValue());
        }
        DLog.e("SharedPrefsUtil is not yet initialized");
        return false;
    }

    public void setBoolean(String key, Boolean val) {
        this.mContext.getSharedPreferences(PREFS_NAME, 0).edit().putBoolean(key, val.booleanValue()).apply();
    }

    public int getInt(String key, int defl) {
        if (this.mContext != null) {
            return this.mContext.getSharedPreferences(PREFS_NAME, 0).getInt(key, defl);
        }
        DLog.e("SharedPrefsUtil is not yet initialized");
        return 0;
    }

    public void setInt(String key, int val) {
        this.mContext.getSharedPreferences(PREFS_NAME, 0).edit().putInt(key, val).apply();
    }
}

