/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import in.co.dipankar.quickandorid.utils.IPlayer;
import java.io.IOException;
import java.util.HashMap;

public class Player
implements IPlayer {
    private boolean mIsPaused = false;
    private static MediaPlayer mPlayer;
    private IPlayerCallback mPlayerCallback;
    private static boolean s_playing;
    private static final String TAG = "DIPANKAR :: Player ";
    private String mUrl;
    private String mTitle;
    private int mTotalDuration;
    private Handler mHandler = new Handler();
    private Runnable mUpdateTimeTask = new Runnable(){

        @Override
        public void run() {
            if (mPlayer != null && mPlayer.isPlaying()) {
                int totalDuration = mPlayer.getDuration();
                int currentDuration = mPlayer.getCurrentPosition();
                Player.this.onSeekBarPossionUpdate(totalDuration, currentDuration);
                Player.this.mHandler.postDelayed((Runnable)this, 1000L);
            }
        }
    };

    public Player(IPlayerCallback playerCallback) {
        this.mPlayerCallback = playerCallback;
        this.init();
    }

    @Override
    public void stop() {
        this.mIsPaused = false;
        if (mPlayer != null) {
            mPlayer.stop();
            mPlayer.reset();
            mPlayer = null;
        }
        s_playing = false;
    }

    @Override
    public boolean isPlaying() {
        return mPlayer != null && mPlayer.isPlaying();
    }

    @Override
    public void pause() {
        Log.d((String)TAG, (String)"Pause Called");
        if (mPlayer != null && mPlayer.isPlaying()) {
            mPlayer.pause();
            this.mPlayerCallback.onPause(this.mTitle);
            this.mIsPaused = true;
        }
    }

    @Override
    public void resume() {
        Log.d((String)TAG, (String)"Resume Called");
        if (mPlayer != null && !mPlayer.isPlaying()) {
            mPlayer.start();
            this.mPlayerCallback.onResume(this.mTitle);
            this.mIsPaused = false;
        }
    }

    @Override
    public void restart() {
        Log.d((String)TAG, (String)"Restart Called");
        if (this.mUrl != null) {
            this.play(this.mTitle, this.mUrl);
        }
        this.mIsPaused = false;
    }

    @Override
    public void mute() {
    }

    @Override
    public void unmute() {
    }

    @Override
    public boolean isPaused() {
        return this.mIsPaused;
    }

    public void seekTo(int progress) {
        Log.d((String)TAG, (String)"Pause Called");
        if (s_playing) {
            int msec = (int)((double)this.mTotalDuration * ((double)progress / 100.0));
            mPlayer.seekTo(msec);
        }
    }

    @Override
    public void play(final String title, final String url) {
        Log.d((String)TAG, (String)"Play Called");
        this.mIsPaused = false;
        Thread backgroudThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Player.this.playInternal(title, url);
                }
                catch (IOException e) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            Player.this.onError1(e.getMessage());
                        }
                    });
                }
            }
        });
        backgroudThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playInternal(final String title, String url) throws IOException {
        if (url == null) {
            this.onError1("Invalid URL passed");
            return;
        }
        this.mUrl = url;
        this.mTitle = title;
        this.onTryPlaying(title);
        this.stop();
        this.init();
        try {
            mPlayer.setDataSource(url);
            mPlayer.prepareAsync();
        }
        catch (Exception e) {
            this.onError1("Not able to play because of:" + e.getMessage());
            this.stop();
            e.printStackTrace();
        }
        if (mPlayer == null) {
            return;
        }
        mPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer player) {
                mPlayer.start();
                Player.this.mTotalDuration = mPlayer.getDuration();
                Player.this.onSuccess(title);
                Player.this.onMusicInfo(new HashMap<String, Object>(){
                    {
                        this.put("CurrentPosition", mPlayer.getCurrentPosition());
                        this.put("Duration", mPlayer.getDuration());
                        this.put("count", "1");
                    }
                });
                Player.this.mHandler.postDelayed(Player.this.mUpdateTimeTask, 1000L);
            }
        });
        mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                Player.this.onComplete(title);
            }
        });
        mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                Player.this.onError1("MediaPlayer error happened");
                return true;
            }
        });
        s_playing = true;
    }

    private void onError1(final String msg) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Player.this.mPlayerCallback.onError(msg);
            }
        });
    }

    private void onTryPlaying(final String msg) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Player.this.mPlayerCallback.onTryPlaying(msg);
            }
        });
    }

    private void onSuccess(final String msg) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Player.this.mPlayerCallback.onSuccess(msg);
            }
        });
    }

    private void onComplete(final String msg) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Player.this.mPlayerCallback.onComplete(msg);
            }
        });
    }

    private void onMusicInfo(final HashMap<String, Object> info) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Player.this.mPlayerCallback.onMusicInfo(info);
            }
        });
    }

    private void onSeekBarPossionUpdate(final int total, final int cur) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Player.this.mPlayerCallback.onSeekBarPossionUpdate(total, cur);
            }
        });
    }

    private void init() {
        if (mPlayer == null) {
            Log.d((String)TAG, (String)"creating new instnace of MediaPlayer ");
            mPlayer = new MediaPlayer();
            mPlayer.setAudioStreamType(3);
        }
    }

    static {
        s_playing = false;
    }

    public static interface IPlayerCallback {
        public void onTryPlaying(String var1);

        public void onSuccess(String var1);

        public void onResume(String var1);

        public void onPause(String var1);

        public void onMusicInfo(HashMap<String, Object> var1);

        public void onSeekBarPossionUpdate(int var1, int var2);

        public void onError(String var1);

        public void onComplete(String var1);
    }
}

