/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import in.co.dipankar.quickandorid.utils.AndroidUtils;
import in.co.dipankar.quickandorid.utils.INetwork;
import in.co.dipankar.quickandorid.utils.Network;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GateKeeperUtils {
    private static String TAG = "DIPANKAR";
    private static final String MY_PREFS_NAME = "GK_FILE";
    Map<String, String> configMap;
    private Context mContext;
    private INetwork mNetwork;

    public void GateKeeperUtils(Context context, INetwork network, String remoteUrl) {
        this.mContext = context;
        this.mNetwork = network;
        this._downlaodAndSaveRemoteConfirg(remoteUrl);
    }

    public boolean isFeatureEnabled(String gk_name, boolean defl) {
        SharedPreferences prefs = this.mContext.getSharedPreferences(MY_PREFS_NAME, 0);
        String restoredText = prefs.getString(gk_name, null);
        if (restoredText != null) {
            if (restoredText.toLowerCase().equals("true") || restoredText.toLowerCase().equals("1")) {
                return true;
            }
            int num = this._getStringInt(restoredText);
            return this._rollDie(num);
        }
        return defl;
    }

    public boolean isDebugOnlyFeature() {
        return AndroidUtils.isDebug();
    }

    public String getRemoteSetting(String gk_name, String defl) {
        SharedPreferences prefs = this.mContext.getSharedPreferences(MY_PREFS_NAME, 0);
        String restoredText = prefs.getString(gk_name, null);
        if (restoredText != null) {
            return restoredText;
        }
        return defl;
    }

    private boolean _rollDie(int percentGiven) {
        Random rand = new Random();
        int roll = rand.nextInt(100);
        return roll < percentGiven;
    }

    private int _getStringInt(String s) {
        try {
            int num = Integer.parseInt(s);
            if (num >= 0 && num <= 100) {
                return num;
            }
            return 0;
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private void _downlaodAndSaveRemoteConfirg(String remoteUrl) {
        this.mNetwork.retrive(remoteUrl, Network.CacheControl.GET_LIVE_ONLY, new Network.Callback(){

            @Override
            public void onSuccess(JSONObject jsonObject) {
                HashMap<String, String> map = new HashMap<String, String>();
                try {
                    JSONArray Jarray = jsonObject.getJSONArray("out");
                    for (int i = 0; i < Jarray.length(); ++i) {
                        JSONObject object = Jarray.getJSONObject(i);
                        if (!object.has("gk_name") || !object.has("gk_value")) continue;
                        map.put(object.getString("gk_name"), object.getString("gk_value"));
                    }
                    if (map.size() > 0) {
                        GateKeeperUtils.this.configMap = map;
                        SharedPreferences.Editor editor = GateKeeperUtils.this.mContext.getSharedPreferences(GateKeeperUtils.MY_PREFS_NAME, 0).edit();
                        for (Map.Entry<String, String> entry : GateKeeperUtils.this.configMap.entrySet()) {
                            editor.putString(entry.getKey().toString(), entry.getValue().toString());
                        }
                        editor.apply();
                        Log.d((String)TAG, (String)"GateKeep configuration loaded successfully!");
                    }
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)("ERROR104" + e.getMessage()));
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(String msg) {
            }
        });
    }
}

