/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class FileDownloadUtils {
    private final String TAG = "DIPANKAR";
    private boolean mIsDebug = false;

    public FileDownloadUtils(boolean debug) {
        this.mIsDebug = debug;
    }

    public void download(final String url, final Callback diskSearchCallback) {
        Thread backgroudThread = new Thread(new Runnable(){

            @Override
            public void run() {
                FileDownloadUtils.this._downloadInternal(url, diskSearchCallback);
            }
        });
        backgroudThread.start();
    }

    private void _downloadInternal(String surl, final Callback diskSearchCallback) {
        int count = 0;
        try {
            File f;
            URL url = new URL(surl);
            String songname = url.getFile();
            songname = songname.substring(songname.lastIndexOf("/") + 1);
            File cacheDir = new File(Environment.getExternalStorageDirectory(), "Offline");
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            if (!(f = new File(cacheDir, songname + ".mp3")).getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            if (f.exists()) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)"DIPANKAR", (String)"File already exist skipping downlaods");
                        diskSearchCallback.onComplete(f.getAbsolutePath());
                    }
                });
                return;
            }
            f.createNewFile();
            BufferedInputStream input = new BufferedInputStream(url.openStream());
            FileOutputStream output = new FileOutputStream(f);
            final String filepath = f.getAbsolutePath();
            URLConnection conexion = url.openConnection();
            conexion.connect();
            int lenghtOfFile = conexion.getContentLength();
            byte[] data = new byte[1024];
            long total = 0L;
            while ((count = ((InputStream)input).read(data)) != -1) {
                final float rate = (total += (long)count) * 100L / (long)lenghtOfFile;
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        diskSearchCallback.onProgress(rate);
                    }
                });
                ((OutputStream)output).write(data, 0, count);
            }
            output.flush();
            ((OutputStream)output).close();
            ((InputStream)input).close();
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    diskSearchCallback.onComplete(filepath);
                }
            });
        }
        catch (Exception e) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    diskSearchCallback.onError(e.getMessage());
                }
            });
        }
    }

    public static interface Callback {
        public void onComplete(String var1);

        public void onProgress(float var1);

        public void onError(String var1);
    }
}

