/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DiskSearchUtils {
    private boolean mIsDebug = false;

    public DiskSearchUtils(boolean isDebug) {
        this.mIsDebug = isDebug;
    }

    public void search(String ext, Callback diskSearchCallback) {
        String rootPath = Environment.getExternalStorageDirectory().getPath() + "/";
        this.search(rootPath, ext, diskSearchCallback);
    }

    public void search(String rootPath, String ext, Callback diskSearchCallback) {
        this._searchInternal(rootPath, ext, diskSearchCallback);
    }

    private void _searchInternal(final String rootPath, final String ext, final Callback diskSearchCallback) {
        Thread backgroudThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    final ArrayList result = DiskSearchUtils.this.getPlayList(rootPath, ext);
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            if (result == null) {
                                diskSearchCallback.onError("Error Not able to serach file..");
                            } else {
                                diskSearchCallback.onComplete(result);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            diskSearchCallback.onError(e.getMessage());
                        }
                    });
                }
            }
        });
        backgroudThread.start();
    }

    private ArrayList<HashMap<String, String>> getPlayList(String rootPath, String ext) throws IOException {
        ArrayList<HashMap<String, String>> fileList = new ArrayList<HashMap<String, String>>();
        File rootFolder = new File(rootPath);
        File[] files = rootFolder.listFiles();
        if (files == null) {
            return fileList;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                if (this.getPlayList(file.getAbsolutePath(), ext) == null) break;
                fileList.addAll(this.getPlayList(file.getAbsolutePath(), ext));
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(ext.toLowerCase())) continue;
            HashMap<String, String> song = new HashMap<String, String>();
            song.put("path", file.getAbsolutePath());
            song.put("name", file.getName());
            fileList.add(song);
        }
        return fileList;
    }

    public static interface Callback {
        public void onComplete(List<HashMap<String, String>> var1);

        public void onError(String var1);
    }
}

