/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Switch;
import android.widget.TextView;
import in.co.dipankar.quickandorid.R;
import in.co.dipankar.quickandorid.activity.SettingCategories;
import in.co.dipankar.quickandorid.activity.SettingItem;
import in.co.dipankar.quickandorid.utils.DLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingActivity
extends Activity {
    private Map<String, DialogInterface> dialogMap;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setOrientation(1);
        LinearLayout.LayoutParams rlp = new LinearLayout.LayoutParams(-1, -1);
        linearLayout.setPadding(this.D2P(15), this.D2P(5), this.D2P(15), this.D2P(5));
        this.buildView((Context)this, linearLayout, this.getSettingCategories());
        linearLayout.setBackgroundColor(Color.parseColor((String)"#ffffff"));
        this.setContentView((View)linearLayout, (ViewGroup.LayoutParams)rlp);
        this.dialogMap = new HashMap<String, DialogInterface>();
    }

    public List<ISettingCategories> getSettingCategories() {
        CharSequence[] cs = new CharSequence[]{"one", "two", "three"};
        ArrayList<ISettingItem> mTestSettingList = new ArrayList<ISettingItem>();
        mTestSettingList.add(new SettingItem("text", "Text", "This is a simple text", SettingType.TEXT, null, null));
        mTestSettingList.add(new SettingItem("switch", "Switch", "This is a simple Switch", SettingType.SWITCH, "true", null));
        mTestSettingList.add(new SettingItem("options", "OPTIONS", "This is a simple options", SettingType.OPTIONS, "one", cs));
        mTestSettingList.add(new SettingItem("input", "Input", "This is a simple Input", SettingType.INPUT, "", null));
        ArrayList<ISettingCategories> mCategories = new ArrayList<ISettingCategories>();
        mCategories.add(new SettingCategories("Test Categories", "This is a sample categories", true, mTestSettingList));
        return mCategories;
    }

    private void buildView(final Context context, LinearLayout rootView, List<ISettingCategories> categoriesList) {
        for (ISettingCategories categories : categoriesList) {
            LinearLayout categoriesView = new LinearLayout(context);
            LinearLayout.LayoutParams llp1 = new LinearLayout.LayoutParams(-1, -2);
            llp1.setMargins(0, 0, 0, this.D2P(35));
            categoriesView.setLayoutParams((ViewGroup.LayoutParams)llp1);
            categoriesView.setOrientation(1);
            TextView titleView = new TextView((Context)this);
            titleView.setText((CharSequence)categories.getName());
            titleView.setTextSize(18.0f);
            titleView.setTypeface(null, 1);
            titleView.setTextColor(Color.parseColor((String)"#5D4037"));
            LinearLayout.LayoutParams llp2 = new LinearLayout.LayoutParams(-1, -2);
            llp2.setMargins(0, 0, 0, this.D2P(15));
            categoriesView.setLayoutParams((ViewGroup.LayoutParams)llp2);
            categoriesView.addView((View)titleView);
            for (final ISettingItem settingItem : categories.getSettingItems()) {
                RelativeLayout itemView = new RelativeLayout(context);
                RelativeLayout.LayoutParams rlm1 = new RelativeLayout.LayoutParams(-1, -2);
                rlm1.setMargins(0, this.D2P(15), 0, 0);
                itemView.setBackground(this.getResources().getDrawable(R.drawable.border));
                itemView.setLayoutParams((ViewGroup.LayoutParams)rlm1);
                TextView itemTitleView = new TextView((Context)this);
                RelativeLayout.LayoutParams rlm2 = new RelativeLayout.LayoutParams(-1, -2);
                rlm2.setMargins(0, 0, 20, 5);
                itemTitleView.setLayoutParams((ViewGroup.LayoutParams)rlm2);
                itemTitleView.setText((CharSequence)settingItem.getName());
                itemTitleView.setTextSize(17.0f);
                itemTitleView.setTextColor(Color.parseColor((String)"#795548"));
                itemView.addView((View)itemTitleView);
                TextView ItemDescView = new TextView((Context)this);
                ItemDescView.setText((CharSequence)settingItem.getDescription());
                RelativeLayout.LayoutParams rlm3 = new RelativeLayout.LayoutParams(-1, -2);
                rlm3.setMargins(0, 70, 20, this.D2P(15));
                rlm3.addRule(3, itemTitleView.getId());
                ItemDescView.setTypeface(null, 2);
                ItemDescView.setLayoutParams((ViewGroup.LayoutParams)rlm3);
                ItemDescView.setTextSize(14.0f);
                ItemDescView.setTextColor(Color.parseColor((String)"#D7CCC8"));
                itemView.addView((View)ItemDescView);
                switch (settingItem.getType()) {
                    case TEXT: {
                        TextView simpleText = new TextView(context);
                        simpleText.setText((CharSequence)settingItem.getDefaultValue());
                        RelativeLayout.LayoutParams rlm4 = new RelativeLayout.LayoutParams(-2, -2);
                        simpleText.setLayoutParams((ViewGroup.LayoutParams)rlm4);
                        itemView.addView((View)simpleText);
                        break;
                    }
                    case INPUT: {
                        final TextView simpleInput = new TextView(context);
                        simpleInput.setText((CharSequence)this.getValueForKey(settingItem.getKey(), settingItem.getDefaultValue()));
                        RelativeLayout.LayoutParams rlm5 = new RelativeLayout.LayoutParams(-2, -2);
                        rlm5.addRule(11, -1);
                        rlm5.addRule(15);
                        simpleInput.setLayoutParams((ViewGroup.LayoutParams)rlm5);
                        simpleInput.setTextSize(16.0f);
                        itemView.addView((View)simpleInput);
                        itemView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                AlertDialog alertDialog1 = null;
                                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                                builder.setTitle((CharSequence)"Enter the input");
                                final EditText input = new EditText(context);
                                input.setInputType(129);
                                builder.setView((View)input);
                                builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialog, int which) {
                                        simpleInput.setText((CharSequence)input.getText().toString());
                                        SettingActivity.this.setValueForKey(settingItem.getKey(), input.getText().toString());
                                        SettingActivity.this.getDialog(settingItem.getKey()).dismiss();
                                    }
                                });
                                builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialog, int which) {
                                        SettingActivity.this.getDialog(settingItem.getKey()).dismiss();
                                    }
                                });
                                alertDialog1 = builder.create();
                                alertDialog1.show();
                                SettingActivity.this.setDialog(settingItem.getKey(), (DialogInterface)alertDialog1);
                            }
                        });
                        break;
                    }
                    case SWITCH: {
                        Switch simpleSwitch = new Switch(context);
                        simpleSwitch.setChecked(this.getValueForKey(settingItem.getKey(), settingItem.getDefaultValue()).equals("true"));
                        RelativeLayout.LayoutParams rlm6 = new RelativeLayout.LayoutParams(-2, -2);
                        rlm6.addRule(11, -1);
                        rlm6.addRule(15);
                        simpleSwitch.setLayoutParams((ViewGroup.LayoutParams)rlm6);
                        itemView.addView((View)simpleSwitch);
                        break;
                    }
                    case OPTIONS: {
                        assert (settingItem.getPossibleValue() != null);
                        final TextView simpleOpt = new TextView(context);
                        simpleOpt.setText((CharSequence)this.getValueForKey(settingItem.getKey(), settingItem.getDefaultValue()));
                        RelativeLayout.LayoutParams rlm7 = new RelativeLayout.LayoutParams(-2, -2);
                        rlm7.addRule(11, -1);
                        rlm7.addRule(15);
                        simpleOpt.setLayoutParams((ViewGroup.LayoutParams)rlm7);
                        simpleOpt.setTextSize(16.0f);
                        itemView.addView((View)simpleOpt);
                        itemView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                AlertDialog alertDialog1 = null;
                                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                                builder.setTitle((CharSequence)"Select Your Choice");
                                AlertDialog finalAlertDialog = alertDialog1;
                                builder.setSingleChoiceItems(settingItem.getPossibleValue(), -1, new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialog, int item) {
                                        String value = settingItem.getPossibleValue()[item].toString();
                                        simpleOpt.setText((CharSequence)value);
                                        SettingActivity.this.setValueForKey(settingItem.getKey(), value);
                                        SettingActivity.this.getDialog(settingItem.getKey()).dismiss();
                                    }
                                });
                                alertDialog1 = builder.create();
                                alertDialog1.show();
                                SettingActivity.this.setDialog(settingItem.getKey(), (DialogInterface)alertDialog1);
                            }
                        });
                    }
                }
                categoriesView.addView((View)itemView);
            }
            rootView.addView((View)categoriesView);
        }
    }

    private DialogInterface getDialog(String key) {
        return this.dialogMap.get(key);
    }

    private void setDialog(String key, DialogInterface dialog) {
        this.dialogMap.put(key, dialog);
    }

    private void setValueForKey(String key, String value) {
        DLog.e("setValueForKey:" + key + ":" + value);
    }

    private String getValueForKey(String key, String value) {
        DLog.e("getValueForKey:" + key + ":" + value);
        return value;
    }

    private int D2P(int dp) {
        return Math.round((float)dp * (this.getResources().getDisplayMetrics().xdpi / 160.0f));
    }

    public static interface ISettingCategories {
        public String getName();

        public String getDesc();

        public boolean isEnable();

        public List<ISettingItem> getSettingItems();
    }

    public static interface ISettingItem {
        public String getKey();

        public String getName();

        public String getDescription();

        public SettingType getType();

        public String getDefaultValue();

        public CharSequence[] getPossibleValue();
    }

    public static enum SettingType {
        TEXT,
        SWITCH,
        OPTIONS,
        INPUT;

    }
}

