/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageButton;
import android.util.AttributeSet;
import android.view.View;
import in.co.dipankar.quickandorid.R;
import java.util.ArrayList;
import java.util.List;

public class MultiStateImageButton
extends AppCompatImageButton
implements View.OnClickListener {
    int currentState = 0;
    List<Drawable> listBackgroud;
    private Callback mCallback;

    public MultiStateImageButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public MultiStateImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MultiStateImageButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.currentState = 1;
        this.listBackgroud = new ArrayList<Drawable>();
        this.setOnClickListener(this);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MultiStateImageButton, 0, 0);
        try {
            Drawable a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState0);
            if (a1 != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState1)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState2)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState3)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState4)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState5)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState6)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState7)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState8)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState9)) != null) {
                this.listBackgroud.add(a1);
            }
            if ((a1 = a.getDrawable(R.styleable.MultiStateImageButton_backgroundState10)) != null) {
                this.listBackgroud.add(a1);
            }
            this.currentState = a.getInteger(R.styleable.MultiStateImageButton_current_state, 0);
        }
        finally {
            a.recycle();
        }
        this.setState(this.currentState);
    }

    public void setState(int idx) {
        this.currentState = idx;
        this.setImageDrawable(this.listBackgroud.get(this.currentState));
    }

    public int getState() {
        return this.currentState;
    }

    public void setCallBack(Callback callback) {
        this.mCallback = callback;
    }

    public void onClick(View v) {
        this.currentState = (this.currentState + 1) % this.listBackgroud.size();
        this.setState(this.currentState);
        if (this.mCallback != null) {
            this.mCallback.click(this.currentState);
        }
    }

    public static interface Callback {
        public void click(int var1);
    }
}

