/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.views;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import in.co.dipankar.quickandorid.R;

public class CustomFontTextView
extends AppCompatTextView {
    private String mFont;
    private Context mContext;

    public CustomFontTextView(Context context) {
        super(context);
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFontTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CustomFontTextView, 0, 0);
        try {
            this.mFont = a.getString(R.styleable.CustomFontTextView_customfont);
            if (this.mFont != null) {
                Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)("fonts/" + this.mFont));
                this.setTypeface(typeface);
            }
        }
        finally {
            a.recycle();
        }
    }

    public String getFont() {
        return this.mFont;
    }

    public void setFont(String mFont) {
        this.mFont = mFont;
        Typeface typeface = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)("fonts/" + mFont));
        this.setTypeface(typeface);
        this.invalidate();
        this.requestLayout();
    }

    public boolean isInEditMode() {
        return true;
    }
}

