/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.authentication.jwt;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.digitalstate.camunda.authentication.jwt.AbstractValidatorJwt;
import io.digitalstate.camunda.authentication.jwt.AuthenticationProviderJwt;
import io.digitalstate.camunda.authentication.jwt.AuthenticationResultJwt;
import io.digitalstate.camunda.authentication.jwt.ValidatorResultJwt;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import org.camunda.bpm.engine.ProcessEngine;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilterJwt
implements AuthenticationProviderJwt,
GroovyObject {
    private static final Logger LOG;
    protected static final String JWT_AUTH_HEADER_PREFIX = "Bearer ";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public AuthenticationFilterJwt() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public AuthenticationResultJwt extractAuthenticatedUser(HttpServletRequest request, ProcessEngine engine, Class jwtValidatorClass, String jwtSecretPath) {
        String authorizationHeader = request.getHeader(HttpHeaders.AUTHORIZATION);
        if (authorizationHeader != null && authorizationHeader.startsWith(JWT_AUTH_HEADER_PREFIX)) {
            String encodedCredentials = authorizationHeader.substring(JWT_AUTH_HEADER_PREFIX.length());
            ValidatorResultJwt validatorResult = null;
            try {
                ValidatorResultJwt validatorResultJwt;
                AbstractValidatorJwt validator = (AbstractValidatorJwt)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance((Class)jwtValidatorClass), AbstractValidatorJwt.class);
                validatorResult = validatorResultJwt = validator.validateJwt(encodedCredentials, jwtSecretPath);
            }
            catch (Exception all) {
                LOG.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{all.getLocalizedMessage()}, new String[]{"Could not load Jwt Validator Class: ", ""})));
                AuthenticationResultJwt authenticationResultJwt = AuthenticationResultJwt.unsuccessful();
                return authenticationResultJwt;
            }
            Boolean bl = validatorResult.getResult();
            if (bl == null ? false : bl) {
                return AuthenticationResultJwt.successful(validatorResult.getAuthenticatedUsername(), validatorResult.getGroupIds(), validatorResult.getTenantIds());
            }
            return AuthenticationResultJwt.unsuccessful();
        }
        LOG.error("JWT: missing JWT header");
        return AuthenticationResultJwt.unsuccessful();
    }

    @Override
    public void augmentResponseByAuthenticationChallenge(HttpServletResponse response, ProcessEngine engine) {
        response.setHeader(HttpHeaders.WWW_AUTHENTICATE, StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)JWT_AUTH_HEADER_PREFIX, (CharSequence)"realm=\""), (CharSequence)engine.getName()), (CharSequence)"\""));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AuthenticationFilterJwt.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOG = logger = LoggerFactory.getLogger(AuthenticationFilterJwt.class);
    }
}

