/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.simpleframework.xml.util.Cache;

public class WeakCache<T>
implements Cache<T> {
    private SegmentList list;

    public WeakCache() {
        this(10);
    }

    public WeakCache(int n) {
        this.list = new SegmentList(n);
    }

    @Override
    public boolean isEmpty() {
        for (Segment segment : this.list) {
            if (segment.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void cache(Object object, T t) {
        this.map(object).cache(object, t);
    }

    @Override
    public T take(Object object) {
        return this.map(object).take(object);
    }

    @Override
    public T fetch(Object object) {
        return this.map(object).fetch(object);
    }

    @Override
    public boolean contains(Object object) {
        return this.map(object).contains(object);
    }

    private Segment map(Object object) {
        return this.list.get(object);
    }

    private class Segment
    extends WeakHashMap<Object, T> {
        private Segment() {
        }

        public synchronized void cache(Object object, T t) {
            this.put(object, t);
        }

        public synchronized T fetch(Object object) {
            return this.get(object);
        }

        public synchronized T take(Object object) {
            return this.remove(object);
        }

        public synchronized boolean contains(Object object) {
            return this.containsKey(object);
        }
    }

    private class SegmentList
    implements Iterable<Segment> {
        private List<Segment> list = new ArrayList<Segment>();
        private int size;

        public SegmentList(int n) {
            this.size = n;
            this.create(n);
        }

        @Override
        public Iterator<Segment> iterator() {
            return this.list.iterator();
        }

        public Segment get(Object object) {
            int n = this.segment(object);
            if (n < this.size) {
                return this.list.get(n);
            }
            return null;
        }

        private void create(int n) {
            int n2 = n;
            while (n2-- > 0) {
                this.list.add(new Segment());
            }
        }

        private int segment(Object object) {
            return Math.abs(object.hashCode() % this.size);
        }
    }
}

