/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.simpleframework.xml.util.Cache;

public class LimitedCache<T>
extends LinkedHashMap<Object, T>
implements Cache<T> {
    private final int capacity;

    public LimitedCache() {
        this(50000);
    }

    public LimitedCache(int n) {
        this.capacity = n;
    }

    @Override
    public void cache(Object object, T t) {
        this.put(object, t);
    }

    @Override
    public T take(Object object) {
        return (T)this.remove(object);
    }

    @Override
    public T fetch(Object object) {
        return (T)this.get(object);
    }

    @Override
    public boolean contains(Object object) {
        return this.containsKey(object);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Object, T> entry) {
        return this.size() > this.capacity;
    }
}

