/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import org.simpleframework.xml.transform.Transform;

class ClassTransform
implements Transform<Class> {
    private static final String INTEGER = "int";
    private static final String DOUBLE = "double";
    private static final String FLOAT = "float";
    private static final String BOOLEAN = "boolean";
    private static final String SHORT = "short";
    private static final String CHARACTER = "char";
    private static final String LONG = "long";
    private static final String BYTE = "byte";
    private static final String VOID = "void";

    ClassTransform() {
    }

    @Override
    public Class read(String string) throws Exception {
        Class clazz = this.readPrimitive(string);
        if (clazz == null) {
            ClassLoader classLoader = ClassTransform.getClassLoader();
            if (classLoader == null) {
                classLoader = this.getCallerClassLoader();
            }
            return classLoader.loadClass(string);
        }
        return clazz;
    }

    private Class readPrimitive(String string) throws Exception {
        if (string.equals(BYTE)) {
            return Byte.TYPE;
        }
        if (string.equals(SHORT)) {
            return Short.TYPE;
        }
        if (string.equals(INTEGER)) {
            return Integer.TYPE;
        }
        if (string.equals(LONG)) {
            return Long.TYPE;
        }
        if (string.equals(CHARACTER)) {
            return Character.TYPE;
        }
        if (string.equals(FLOAT)) {
            return Float.TYPE;
        }
        if (string.equals(DOUBLE)) {
            return Double.TYPE;
        }
        if (string.equals(BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (string.equals(VOID)) {
            return Void.TYPE;
        }
        return null;
    }

    @Override
    public String write(Class clazz) throws Exception {
        return clazz.getName();
    }

    private ClassLoader getCallerClassLoader() {
        return this.getClass().getClassLoader();
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

