/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.lang.reflect.Array;
import org.simpleframework.xml.transform.StringArrayTransform;
import org.simpleframework.xml.transform.Transform;

class ArrayTransform
implements Transform {
    private final StringArrayTransform split = new StringArrayTransform();
    private final Transform delegate;
    private final Class entry;

    public ArrayTransform(Transform transform, Class clazz) {
        this.delegate = transform;
        this.entry = clazz;
    }

    public Object read(String string) throws Exception {
        String[] stringArray = this.split.read(string);
        int n = stringArray.length;
        return this.read(stringArray, n);
    }

    private Object read(String[] stringArray, int n) throws Exception {
        Object object = Array.newInstance(this.entry, n);
        for (int i = 0; i < n; ++i) {
            Object t = this.delegate.read(stringArray[i]);
            if (t == null) continue;
            Array.set(object, i, t);
        }
        return object;
    }

    public String write(Object object) throws Exception {
        int n = Array.getLength(object);
        return this.write(object, n);
    }

    private String write(Object object, int n) throws Exception {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 == null) continue;
            stringArray[i] = this.delegate.write(object2);
        }
        return this.split.write(stringArray);
    }
}

