/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.util.Iterator;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.simpleframework.xml.stream.EventAttribute;
import org.simpleframework.xml.stream.EventElement;
import org.simpleframework.xml.stream.EventNode;
import org.simpleframework.xml.stream.EventReader;
import org.simpleframework.xml.stream.EventToken;

class StreamReader
implements EventReader {
    private XMLEventReader reader;
    private EventNode peek;

    public StreamReader(XMLEventReader xMLEventReader) {
        this.reader = xMLEventReader;
    }

    @Override
    public EventNode peek() throws Exception {
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    @Override
    public EventNode next() throws Exception {
        EventNode eventNode = this.peek;
        if (eventNode == null) {
            eventNode = this.read();
        } else {
            this.peek = null;
        }
        return eventNode;
    }

    private EventNode read() throws Exception {
        XMLEvent xMLEvent = this.reader.nextEvent();
        if (!xMLEvent.isEndDocument()) {
            if (xMLEvent.isStartElement()) {
                return this.start(xMLEvent);
            }
            if (xMLEvent.isCharacters()) {
                return this.text(xMLEvent);
            }
            if (xMLEvent.isEndElement()) {
                return this.end();
            }
            return this.read();
        }
        return null;
    }

    private Start start(XMLEvent xMLEvent) {
        Start start = new Start(xMLEvent);
        if (start.isEmpty()) {
            return this.build(start);
        }
        return start;
    }

    private Start build(Start start) {
        Iterator<Attribute> iterator = start.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            Entry entry = this.attribute(attribute);
            if (entry.isReserved()) continue;
            start.add(entry);
        }
        return start;
    }

    private Entry attribute(Attribute attribute) {
        return new Entry(attribute);
    }

    private Text text(XMLEvent xMLEvent) {
        return new Text(xMLEvent);
    }

    private End end() {
        return new End();
    }

    private static class End
    extends EventToken {
        private End() {
        }

        @Override
        public boolean isEnd() {
            return true;
        }
    }

    private static class Text
    extends EventToken {
        private final Characters text;

        public Text(XMLEvent xMLEvent) {
            this.text = xMLEvent.asCharacters();
        }

        @Override
        public boolean isText() {
            return true;
        }

        @Override
        public String getValue() {
            return this.text.getData();
        }

        @Override
        public Object getSource() {
            return this.text;
        }
    }

    private static class Start
    extends EventElement {
        private final StartElement element;
        private final Location location;

        public Start(XMLEvent xMLEvent) {
            this.element = xMLEvent.asStartElement();
            this.location = xMLEvent.getLocation();
        }

        @Override
        public int getLine() {
            return this.location.getLineNumber();
        }

        @Override
        public String getName() {
            return this.element.getName().getLocalPart();
        }

        @Override
        public String getPrefix() {
            return this.element.getName().getPrefix();
        }

        @Override
        public String getReference() {
            return this.element.getName().getNamespaceURI();
        }

        public Iterator<Attribute> getAttributes() {
            return this.element.getAttributes();
        }

        @Override
        public Object getSource() {
            return this.element;
        }
    }

    private static class Entry
    extends EventAttribute {
        private final Attribute entry;

        public Entry(Attribute attribute) {
            this.entry = attribute;
        }

        @Override
        public String getName() {
            return this.entry.getName().getLocalPart();
        }

        @Override
        public String getPrefix() {
            return this.entry.getName().getPrefix();
        }

        @Override
        public String getReference() {
            return this.entry.getName().getNamespaceURI();
        }

        @Override
        public String getValue() {
            return this.entry.getValue();
        }

        @Override
        public boolean isReserved() {
            return false;
        }

        @Override
        public Object getSource() {
            return this.entry;
        }
    }
}

