/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.simpleframework.xml.stream.OutputNode;

class OutputStack
extends ArrayList<OutputNode> {
    private final Set active;

    public OutputStack(Set set) {
        this.active = set;
    }

    public OutputNode pop() {
        int n = this.size();
        if (n <= 0) {
            return null;
        }
        return this.purge(n - 1);
    }

    public OutputNode top() {
        int n = this.size();
        if (n <= 0) {
            return null;
        }
        return (OutputNode)this.get(n - 1);
    }

    public OutputNode bottom() {
        int n = this.size();
        if (n <= 0) {
            return null;
        }
        return (OutputNode)this.get(0);
    }

    public OutputNode push(OutputNode outputNode) {
        this.active.add(outputNode);
        this.add(outputNode);
        return outputNode;
    }

    public OutputNode purge(int n) {
        OutputNode outputNode = (OutputNode)this.remove(n);
        if (outputNode != null) {
            this.active.remove(outputNode);
        }
        return outputNode;
    }

    @Override
    public Iterator<OutputNode> iterator() {
        return new Sequence();
    }

    private class Sequence
    implements Iterator<OutputNode> {
        private int cursor;

        public Sequence() {
            this.cursor = OutputStack.this.size();
        }

        @Override
        public OutputNode next() {
            if (this.hasNext()) {
                return (OutputNode)OutputStack.this.get(--this.cursor);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.cursor > 0;
        }

        @Override
        public void remove() {
            OutputStack.this.purge(this.cursor);
        }
    }
}

