/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import org.simpleframework.xml.stream.EventNode;
import org.simpleframework.xml.stream.EventReader;
import org.simpleframework.xml.stream.InputElement;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.InputStack;
import org.simpleframework.xml.stream.NodeException;

class NodeReader {
    private final StringBuilder text = new StringBuilder();
    private final EventReader reader;
    private final InputStack stack = new InputStack();

    public NodeReader(EventReader eventReader) {
        this.reader = eventReader;
    }

    public boolean isRoot(InputNode inputNode) {
        return this.stack.bottom() == inputNode;
    }

    public InputNode readRoot() throws Exception {
        if (this.stack.isEmpty()) {
            InputNode inputNode = this.readElement(null);
            if (inputNode == null) {
                throw new NodeException("Document has no root element");
            }
            return inputNode;
        }
        return null;
    }

    public InputNode readElement(InputNode inputNode) throws Exception {
        if (!this.stack.isRelevant(inputNode)) {
            return null;
        }
        EventNode eventNode = this.reader.next();
        while (eventNode != null) {
            if (eventNode.isEnd()) {
                if (this.stack.pop() == inputNode) {
                    return null;
                }
            } else if (eventNode.isStart()) {
                return this.readStart(inputNode, eventNode);
            }
            eventNode = this.reader.next();
        }
        return null;
    }

    public InputNode readElement(InputNode inputNode, String string) throws Exception {
        if (!this.stack.isRelevant(inputNode)) {
            return null;
        }
        EventNode eventNode = this.reader.peek();
        while (eventNode != null) {
            if (eventNode.isText()) {
                this.fillText(inputNode);
            } else if (eventNode.isEnd()) {
                if (this.stack.top() == inputNode) {
                    return null;
                }
                this.stack.pop();
            } else if (eventNode.isStart()) {
                if (!this.isName(eventNode, string)) break;
                return this.readElement(inputNode);
            }
            eventNode = this.reader.next();
            eventNode = this.reader.peek();
        }
        return null;
    }

    private InputNode readStart(InputNode inputNode, EventNode eventNode) throws Exception {
        InputElement inputElement = new InputElement(inputNode, this, eventNode);
        if (this.text.length() > 0) {
            this.text.setLength(0);
        }
        if (eventNode.isStart()) {
            return this.stack.push(inputElement);
        }
        return inputElement;
    }

    private boolean isName(EventNode eventNode, String string) {
        String string2 = eventNode.getName();
        if (string2 == null) {
            return false;
        }
        return string2.equals(string);
    }

    public String readValue(InputNode inputNode) throws Exception {
        EventNode eventNode;
        if (!this.stack.isRelevant(inputNode)) {
            return null;
        }
        int n = this.text.length();
        if (n <= 0 && (eventNode = this.reader.peek()).isEnd()) {
            if (this.stack.top() == inputNode) {
                return null;
            }
            this.stack.pop();
            eventNode = this.reader.next();
        }
        return this.readText(inputNode);
    }

    private String readText(InputNode inputNode) throws Exception {
        EventNode eventNode = this.reader.peek();
        while (this.stack.top() == inputNode && eventNode.isText()) {
            this.fillText(inputNode);
            eventNode = this.reader.next();
            eventNode = this.reader.peek();
        }
        return this.readBuffer(inputNode);
    }

    private String readBuffer(InputNode inputNode) throws Exception {
        int n = this.text.length();
        if (n > 0) {
            String string = this.text.toString();
            this.text.setLength(0);
            return string;
        }
        return null;
    }

    private void fillText(InputNode inputNode) throws Exception {
        EventNode eventNode = this.reader.peek();
        if (eventNode.isText()) {
            String string = eventNode.getValue();
            this.text.append(string);
        }
    }

    public boolean isEmpty(InputNode inputNode) throws Exception {
        EventNode eventNode;
        return this.stack.top() == inputNode && (eventNode = this.reader.peek()).isEnd();
    }

    public void skipElement(InputNode inputNode) throws Exception {
        while (this.readElement(inputNode) != null) {
        }
    }
}

