/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.simpleframework.xml.stream.Attribute;
import org.simpleframework.xml.stream.EventNode;
import org.simpleframework.xml.stream.InputAttribute;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;

class InputNodeMap
extends LinkedHashMap<String, InputNode>
implements NodeMap<InputNode> {
    private final InputNode source;

    protected InputNodeMap(InputNode inputNode) {
        this.source = inputNode;
    }

    public InputNodeMap(InputNode inputNode, EventNode eventNode) {
        this.source = inputNode;
        this.build(eventNode);
    }

    private void build(EventNode eventNode) {
        for (Attribute attribute : eventNode) {
            InputAttribute inputAttribute = new InputAttribute(this.source, attribute);
            if (attribute.isReserved()) continue;
            this.put(inputAttribute.getName(), inputAttribute);
        }
    }

    @Override
    public InputNode getNode() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.source.getName();
    }

    @Override
    public InputNode put(String string, String string2) {
        InputAttribute inputAttribute = new InputAttribute(this.source, string, string2);
        if (string != null) {
            this.put(string, inputAttribute);
        }
        return inputAttribute;
    }

    @Override
    public InputNode remove(String string) {
        return (InputNode)super.remove(string);
    }

    @Override
    public InputNode get(String string) {
        return (InputNode)super.get(string);
    }

    @Override
    public Iterator<String> iterator() {
        return this.keySet().iterator();
    }
}

