/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import org.simpleframework.xml.stream.Format;

class Indenter {
    private Cache cache;
    private int indent;
    private int count;
    private int index;

    public Indenter() {
        this(new Format());
    }

    public Indenter(Format format) {
        this(format, 16);
    }

    private Indenter(Format format, int n) {
        this.indent = format.getIndent();
        this.cache = new Cache(n);
    }

    public String top() {
        return this.indent(this.index);
    }

    public String push() {
        String string = this.indent(this.index++);
        if (this.indent > 0) {
            this.count += this.indent;
        }
        return string;
    }

    public String pop() {
        String string = this.indent(--this.index);
        if (this.indent > 0) {
            this.count -= this.indent;
        }
        return string;
    }

    private String indent(int n) {
        if (this.indent > 0) {
            String string = this.cache.get(n);
            if (string == null) {
                string = this.create();
                this.cache.set(n, string);
            }
            if (this.cache.size() > 0) {
                return string;
            }
        }
        return "";
    }

    private String create() {
        char[] cArray = new char[this.count + 1];
        if (this.count > 0) {
            cArray[0] = 10;
            for (int i = 1; i <= this.count; ++i) {
                cArray[i] = 32;
            }
            return new String(cArray);
        }
        return "\n";
    }

    private static class Cache {
        private String[] list;
        private int count;

        public Cache(int n) {
            this.list = new String[n];
        }

        public int size() {
            return this.count;
        }

        public void set(int n, String string) {
            if (n >= this.list.length) {
                this.resize(n * 2);
            }
            if (n > this.count) {
                this.count = n;
            }
            this.list[n] = string;
        }

        public String get(int n) {
            if (n < this.list.length) {
                return this.list[n];
            }
            return null;
        }

        private void resize(int n) {
            String[] stringArray = new String[n];
            for (int i = 0; i < this.list.length; ++i) {
                stringArray[i] = this.list[i];
            }
            this.list = stringArray;
        }
    }
}

