/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.strategy;

import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import org.simpleframework.xml.strategy.Contract;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.NodeMap;

class WriteGraph
extends IdentityHashMap<Object, String> {
    private final String length;
    private final String label;
    private final String mark;
    private final String refer;

    public WriteGraph(Contract contract) {
        this.refer = contract.getReference();
        this.mark = contract.getIdentity();
        this.length = contract.getLength();
        this.label = contract.getLabel();
    }

    public boolean write(Type type, Object object, NodeMap nodeMap) {
        Class clazz = object.getClass();
        Class clazz2 = type.getType();
        Class clazz3 = clazz;
        if (clazz.isArray()) {
            clazz3 = this.writeArray(clazz, object, nodeMap);
        }
        if (clazz != clazz2) {
            nodeMap.put(this.label, clazz3.getName());
        }
        return this.writeReference(object, nodeMap);
    }

    private boolean writeReference(Object object, NodeMap nodeMap) {
        String string = (String)this.get(object);
        int n = this.size();
        if (string != null) {
            nodeMap.put(this.refer, string);
            return true;
        }
        String string2 = String.valueOf(n);
        nodeMap.put(this.mark, string2);
        this.put(object, string2);
        return false;
    }

    private Class writeArray(Class clazz, Object object, NodeMap nodeMap) {
        int n = Array.getLength(object);
        if (!this.containsKey(object)) {
            nodeMap.put(this.length, String.valueOf(n));
        }
        return clazz.getComponentType();
    }
}

