/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.strategy;

import java.lang.reflect.Array;
import java.util.Map;
import org.simpleframework.xml.strategy.ArrayValue;
import org.simpleframework.xml.strategy.Loader;
import org.simpleframework.xml.strategy.ObjectValue;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.NodeMap;

public class TreeStrategy
implements Strategy {
    private final Loader loader = new Loader();
    private final String length;
    private final String label;

    public TreeStrategy() {
        this("class", "length");
    }

    public TreeStrategy(String string, String string2) {
        this.length = string2;
        this.label = string;
    }

    public Value read(Type type, NodeMap nodeMap, Map map) throws Exception {
        Class clazz = this.readValue(type, nodeMap);
        Class clazz2 = type.getType();
        if (clazz2.isArray()) {
            return this.readArray(clazz, nodeMap);
        }
        if (clazz2 != clazz) {
            return new ObjectValue(clazz);
        }
        return null;
    }

    private Value readArray(Class clazz, NodeMap nodeMap) throws Exception {
        Object t = nodeMap.remove(this.length);
        int n = 0;
        if (t != null) {
            String string = t.getValue();
            n = Integer.parseInt(string);
        }
        return new ArrayValue(clazz, n);
    }

    private Class readValue(Type type, NodeMap nodeMap) throws Exception {
        Object t = nodeMap.remove(this.label);
        Class clazz = type.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (t != null) {
            String string = t.getValue();
            clazz = this.loader.load(string);
        }
        return clazz;
    }

    public boolean write(Type type, Object object, NodeMap nodeMap, Map map) {
        Class clazz = object.getClass();
        Class clazz2 = type.getType();
        Class clazz3 = clazz;
        if (clazz.isArray()) {
            clazz3 = this.writeArray(clazz2, object, nodeMap);
        }
        if (clazz != clazz2) {
            nodeMap.put(this.label, clazz3.getName());
        }
        return false;
    }

    private Class writeArray(Class clazz, Object object, NodeMap nodeMap) {
        int n = Array.getLength(object);
        if (this.length != null) {
            nodeMap.put(this.length, String.valueOf(n));
        }
        return clazz.getComponentType();
    }
}

