/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.Caller;
import org.simpleframework.xml.core.ClassSchema;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Schema;
import org.simpleframework.xml.core.Session;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.core.TemplateEngine;
import org.simpleframework.xml.core.TemplateFilter;
import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class Source
implements Context {
    private TemplateEngine engine;
    private Strategy strategy;
    private Support support;
    private Session session;
    private Filter filter;

    public Source(Strategy strategy, Support support, Session session) {
        this.filter = new TemplateFilter(this, support);
        this.engine = new TemplateEngine(this.filter);
        this.strategy = strategy;
        this.support = support;
        this.session = session;
    }

    @Override
    public boolean isStrict() {
        return this.session.isStrict();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Support getSupport() {
        return this.support;
    }

    @Override
    public Style getStyle() {
        return this.support.getStyle();
    }

    @Override
    public boolean isFloat(Class clazz) throws Exception {
        return Support.isFloat(clazz);
    }

    @Override
    public boolean isFloat(Type type) throws Exception {
        return this.isFloat(type.getType());
    }

    @Override
    public boolean isPrimitive(Class clazz) throws Exception {
        return this.support.isPrimitive(clazz);
    }

    @Override
    public boolean isPrimitive(Type type) throws Exception {
        return this.isPrimitive(type.getType());
    }

    @Override
    public Instance getInstance(Class clazz) {
        return this.support.getInstance(clazz);
    }

    @Override
    public Instance getInstance(Value value) {
        return this.support.getInstance(value);
    }

    @Override
    public String getName(Class clazz) throws Exception {
        return this.support.getName(clazz);
    }

    @Override
    public Version getVersion(Class clazz) throws Exception {
        return this.getScanner(clazz).getRevision();
    }

    private Scanner getScanner(Class clazz) throws Exception {
        return this.support.getScanner(clazz);
    }

    @Override
    public Decorator getDecorator(Class clazz) throws Exception {
        return this.getScanner(clazz).getDecorator();
    }

    @Override
    public Caller getCaller(Class clazz) throws Exception {
        return this.getScanner(clazz).getCaller(this);
    }

    @Override
    public Schema getSchema(Class clazz) throws Exception {
        Scanner scanner = this.getScanner(clazz);
        if (scanner == null) {
            throw new PersistenceException("Invalid schema class %s", clazz);
        }
        return new ClassSchema(scanner, this);
    }

    @Override
    public Object getAttribute(Object object) {
        return this.session.get(object);
    }

    @Override
    public Value getOverride(Type type, InputNode inputNode) throws Exception {
        NodeMap<InputNode> nodeMap = inputNode.getAttributes();
        if (nodeMap == null) {
            throw new PersistenceException("No attributes for %s", inputNode);
        }
        return this.strategy.read(type, nodeMap, this.session);
    }

    @Override
    public boolean setOverride(Type type, Object object, OutputNode outputNode) throws Exception {
        NodeMap<OutputNode> nodeMap = outputNode.getAttributes();
        if (nodeMap == null) {
            throw new PersistenceException("No attributes for %s", outputNode);
        }
        return this.strategy.write(type, object, nodeMap, this.session);
    }

    @Override
    public Class getType(Type type, Object object) {
        if (object != null) {
            return object.getClass();
        }
        return type.getType();
    }

    @Override
    public String getProperty(String string) {
        return this.engine.process(string);
    }
}

