/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.ConstructorException;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.Signature;

class SignatureBuilder {
    private final ParameterTable table = new ParameterTable();
    private final Constructor factory;

    public SignatureBuilder(Constructor constructor) {
        this.factory = constructor;
    }

    public boolean isValid() {
        int n;
        Class<?>[] classArray = this.factory.getParameterTypes();
        return classArray.length == (n = this.table.width());
    }

    public void insert(Parameter parameter, int n) {
        this.table.insert(parameter, n);
    }

    public List<Signature> build() throws Exception {
        return this.build(new ParameterTable());
    }

    private List<Signature> build(ParameterTable parameterTable) throws Exception {
        if (this.table.isEmpty()) {
            return this.create();
        }
        this.build(parameterTable, 0);
        return this.create(parameterTable);
    }

    private List<Signature> create() throws Exception {
        ArrayList<Signature> arrayList = new ArrayList<Signature>();
        Signature signature = new Signature(this.factory);
        if (this.isValid()) {
            arrayList.add(signature);
        }
        return arrayList;
    }

    private List<Signature> create(ParameterTable parameterTable) throws Exception {
        ArrayList<Signature> arrayList = new ArrayList<Signature>();
        int n = parameterTable.height();
        int n2 = parameterTable.width();
        for (int i = 0; i < n; ++i) {
            Signature signature = new Signature(this.factory);
            for (int j = 0; j < n2; ++j) {
                Parameter parameter = parameterTable.get(j, i);
                String string = parameter.getPath();
                Object object = parameter.getKey();
                if (signature.contains(object)) {
                    throw new ConstructorException("Parameter '%s' is a duplicate in %s", string, this.factory);
                }
                signature.add(parameter);
            }
            arrayList.add(signature);
        }
        return arrayList;
    }

    private void build(ParameterTable parameterTable, int n) {
        this.build(parameterTable, new ParameterList(), n);
    }

    private void build(ParameterTable parameterTable, ParameterList parameterList, int n) {
        ParameterList parameterList2 = this.table.get(n);
        int n2 = parameterList2.size();
        int n3 = this.table.width();
        if (n3 - 1 > n) {
            for (int i = 0; i < n2; ++i) {
                ParameterList parameterList3 = new ParameterList(parameterList);
                if (parameterList == null) continue;
                Parameter parameter = (Parameter)parameterList2.get(i);
                parameterList3.add(parameter);
                this.build(parameterTable, parameterList3, n + 1);
            }
        } else {
            this.populate(parameterTable, parameterList, n);
        }
    }

    private void populate(ParameterTable parameterTable, ParameterList parameterList, int n) {
        ParameterList parameterList2 = this.table.get(n);
        int n2 = parameterList.size();
        int n3 = parameterList2.size();
        for (int i = 0; i < n3; ++i) {
            Object object;
            for (int j = 0; j < n2; ++j) {
                object = parameterTable.get(j);
                Parameter parameter = (Parameter)parameterList.get(j);
                ((ArrayList)object).add(parameter);
            }
            ParameterList parameterList3 = parameterTable.get(n);
            object = (Parameter)parameterList2.get(i);
            parameterList3.add(object);
        }
    }

    private static class ParameterList
    extends ArrayList<Parameter> {
        public ParameterList() {
        }

        public ParameterList(ParameterList parameterList) {
            super(parameterList);
        }
    }

    private static class ParameterTable
    extends ArrayList<ParameterList> {
        private int height() {
            int n = this.width();
            if (n > 0) {
                return this.get(0).size();
            }
            return 0;
        }

        private int width() {
            return this.size();
        }

        public void insert(Parameter parameter, int n) {
            ParameterList parameterList = this.get(n);
            if (parameterList != null) {
                parameterList.add(parameter);
            }
        }

        @Override
        public ParameterList get(int n) {
            int n2;
            for (int i = n2 = this.size(); i <= n; ++i) {
                ParameterList parameterList = new ParameterList();
                this.add(parameterList);
            }
            return (ParameterList)super.get(n);
        }

        public Parameter get(int n, int n2) {
            return (Parameter)this.get(n).get(n2);
        }
    }
}

