/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Session;

class SessionManager {
    private ThreadLocal<Reference> local = new ThreadLocal();

    public Session open() throws Exception {
        return this.open(true);
    }

    public Session open(boolean bl) throws Exception {
        Reference reference = this.local.get();
        if (reference != null) {
            return reference.get();
        }
        return this.create(bl);
    }

    private Session create(boolean bl) throws Exception {
        Reference reference = new Reference(bl);
        if (reference != null) {
            this.local.set(reference);
        }
        return reference.get();
    }

    public void close() throws Exception {
        Reference reference = this.local.get();
        if (reference == null) {
            throw new PersistenceException("Session does not exist", new Object[0]);
        }
        int n = reference.clear();
        if (n == 0) {
            this.local.remove();
        }
    }

    private static class Reference {
        private Session session;
        private int count;

        public Reference(boolean bl) {
            this.session = new Session(bl);
        }

        public Session get() {
            if (this.count >= 0) {
                ++this.count;
            }
            return this.session;
        }

        public int clear() {
            return --this.count;
        }
    }
}

