/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.DefaultScanner;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.ObjectScanner;
import org.simpleframework.xml.core.PrimitiveScanner;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class ScannerFactory {
    private final Cache<Scanner> cache = new ConcurrentCache<Scanner>();
    private final Support support;

    public ScannerFactory(Support support) {
        this.support = support;
    }

    public Scanner getInstance(Class clazz) throws Exception {
        Scanner scanner = this.cache.fetch(clazz);
        if (scanner == null) {
            Detail detail = this.support.getDetail(clazz);
            if (this.support.isPrimitive(clazz)) {
                scanner = new PrimitiveScanner(detail);
            } else {
                scanner = new ObjectScanner(detail, this.support);
                if (scanner.isPrimitive() && !this.support.isContainer(clazz)) {
                    scanner = new DefaultScanner(detail, this.support);
                }
            }
            this.cache.cache(clazz, scanner);
        }
        return scanner;
    }
}

