/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Entry;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Primitive;
import org.simpleframework.xml.core.PrimitiveFactory;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class PrimitiveValue
implements Converter {
    private final PrimitiveFactory factory;
    private final Context context;
    private final Primitive root;
    private final Style style;
    private final Entry entry;
    private final Type type;

    public PrimitiveValue(Context context, Entry entry, Type type) {
        this.factory = new PrimitiveFactory(context, type);
        this.root = new Primitive(context, type);
        this.style = context.getStyle();
        this.context = context;
        this.entry = entry;
        this.type = type;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        Class clazz = this.type.getType();
        String string = this.entry.getValue();
        if (!this.entry.isInline()) {
            if (string == null) {
                string = this.context.getName(clazz);
            }
            return this.readElement(inputNode, string);
        }
        return this.readAttribute(inputNode, string);
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        Class clazz = this.type.getType();
        if (object != null) {
            throw new PersistenceException("Can not read value of %s for %s", clazz, this.entry);
        }
        return this.read(inputNode);
    }

    private Object readElement(InputNode inputNode, String string) throws Exception {
        String string2 = this.style.getAttribute(string);
        InputNode inputNode2 = inputNode.getNext(string2);
        if (inputNode2 == null) {
            return null;
        }
        return this.root.read(inputNode2);
    }

    private Object readAttribute(InputNode inputNode, String string) throws Exception {
        if (string != null) {
            string = this.style.getAttribute(string);
            inputNode = inputNode.getAttribute(string);
        }
        if (inputNode == null) {
            return null;
        }
        return this.root.read(inputNode);
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        Class clazz = this.type.getType();
        String string = this.entry.getValue();
        if (!this.entry.isInline()) {
            if (string == null) {
                string = this.context.getName(clazz);
            }
            return this.validateElement(inputNode, string);
        }
        return this.validateAttribute(inputNode, string);
    }

    private boolean validateElement(InputNode inputNode, String string) throws Exception {
        String string2 = this.style.getAttribute(string);
        InputNode inputNode2 = inputNode.getNext(string2);
        if (inputNode2 == null) {
            return true;
        }
        return this.root.validate(inputNode);
    }

    private boolean validateAttribute(InputNode inputNode, String string) throws Exception {
        if (string != null) {
            string = this.style.getAttribute(string);
            inputNode = inputNode.getNext(string);
        }
        if (inputNode == null) {
            return true;
        }
        return this.root.validate(inputNode);
    }

    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        Class clazz = this.type.getType();
        String string = this.entry.getValue();
        if (!this.entry.isInline()) {
            if (string == null) {
                string = this.context.getName(clazz);
            }
            this.writeElement(outputNode, object, string);
        } else {
            this.writeAttribute(outputNode, object, string);
        }
    }

    private void writeElement(OutputNode outputNode, Object object, String string) throws Exception {
        String string2 = this.style.getAttribute(string);
        OutputNode outputNode2 = outputNode.getChild(string2);
        if (object != null && !this.isOverridden(outputNode2, object)) {
            this.root.write(outputNode2, object);
        }
    }

    private void writeAttribute(OutputNode outputNode, Object object, String string) throws Exception {
        if (object != null) {
            if (string != null) {
                string = this.style.getAttribute(string);
                outputNode = outputNode.setAttribute(string, null);
            }
            this.root.write(outputNode, object);
        }
    }

    private boolean isOverridden(OutputNode outputNode, Object object) throws Exception {
        return this.factory.setOverride(this.type, object, outputNode);
    }
}

