/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.ElementMapUnion;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.core.AttributeParameter;
import org.simpleframework.xml.core.ElementArrayParameter;
import org.simpleframework.xml.core.ElementListParameter;
import org.simpleframework.xml.core.ElementListUnionParameter;
import org.simpleframework.xml.core.ElementMapParameter;
import org.simpleframework.xml.core.ElementMapUnionParameter;
import org.simpleframework.xml.core.ElementParameter;
import org.simpleframework.xml.core.ElementUnionParameter;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.core.TextParameter;
import org.simpleframework.xml.stream.Format;

class ParameterFactory {
    private final Format format;

    public ParameterFactory(Support support) {
        this.format = support.getFormat();
    }

    public Parameter getInstance(Constructor constructor, Annotation annotation, int n) throws Exception {
        return this.getInstance(constructor, annotation, null, n);
    }

    public Parameter getInstance(Constructor constructor, Annotation annotation, Annotation annotation2, int n) throws Exception {
        Constructor constructor2 = this.getConstructor(annotation);
        if (annotation2 != null) {
            return (Parameter)constructor2.newInstance(constructor, annotation, annotation2, this.format, n);
        }
        return (Parameter)constructor2.newInstance(constructor, annotation, this.format, n);
    }

    private Constructor getConstructor(Annotation annotation) throws Exception {
        ParameterBuilder parameterBuilder = this.getBuilder(annotation);
        Constructor constructor = parameterBuilder.getConstructor();
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    private ParameterBuilder getBuilder(Annotation annotation) throws Exception {
        if (annotation instanceof Element) {
            return new ParameterBuilder(ElementParameter.class, Element.class);
        }
        if (annotation instanceof ElementList) {
            return new ParameterBuilder(ElementListParameter.class, ElementList.class);
        }
        if (annotation instanceof ElementArray) {
            return new ParameterBuilder(ElementArrayParameter.class, ElementArray.class);
        }
        if (annotation instanceof ElementMapUnion) {
            return new ParameterBuilder(ElementMapUnionParameter.class, ElementMapUnion.class, ElementMap.class);
        }
        if (annotation instanceof ElementListUnion) {
            return new ParameterBuilder(ElementListUnionParameter.class, ElementListUnion.class, ElementList.class);
        }
        if (annotation instanceof ElementUnion) {
            return new ParameterBuilder(ElementUnionParameter.class, ElementUnion.class, Element.class);
        }
        if (annotation instanceof ElementMap) {
            return new ParameterBuilder(ElementMapParameter.class, ElementMap.class);
        }
        if (annotation instanceof Attribute) {
            return new ParameterBuilder(AttributeParameter.class, Attribute.class);
        }
        if (annotation instanceof Text) {
            return new ParameterBuilder(TextParameter.class, Text.class);
        }
        throw new PersistenceException("Annotation %s not supported", annotation);
    }

    private static class ParameterBuilder {
        private final Class entry;
        private final Class label;
        private final Class type;

        public ParameterBuilder(Class clazz, Class clazz2) {
            this(clazz, clazz2, null);
        }

        public ParameterBuilder(Class clazz, Class clazz2, Class clazz3) {
            this.label = clazz2;
            this.entry = clazz3;
            this.type = clazz;
        }

        public Constructor getConstructor() throws Exception {
            if (this.entry != null) {
                return this.getConstructor(this.label, this.entry);
            }
            return this.getConstructor(this.label);
        }

        public Constructor getConstructor(Class clazz) throws Exception {
            return this.getConstructor(Constructor.class, clazz, Format.class, Integer.TYPE);
        }

        public Constructor getConstructor(Class clazz, Class clazz2) throws Exception {
            return this.getConstructor(Constructor.class, clazz, clazz2, Format.class, Integer.TYPE);
        }

        private Constructor getConstructor(Class ... classArray) throws Exception {
            return this.type.getConstructor(classArray);
        }
    }
}

