/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.stream.NamespaceMap;
import org.simpleframework.xml.stream.OutputNode;

class NamespaceDecorator
implements Decorator {
    private List<Namespace> scope = new ArrayList<Namespace>();
    private Namespace primary;

    public void set(Namespace namespace) {
        if (namespace != null) {
            this.add(namespace);
        }
        this.primary = namespace;
    }

    public void add(Namespace namespace) {
        this.scope.add(namespace);
    }

    @Override
    public void decorate(OutputNode outputNode) {
        this.decorate(outputNode, null);
    }

    @Override
    public void decorate(OutputNode outputNode, Decorator decorator) {
        if (decorator != null) {
            decorator.decorate(outputNode);
        }
        this.scope(outputNode);
        this.namespace(outputNode);
    }

    private void scope(OutputNode outputNode) {
        NamespaceMap namespaceMap = outputNode.getNamespaces();
        for (Namespace namespace : this.scope) {
            String string = namespace.reference();
            String string2 = namespace.prefix();
            namespaceMap.setReference(string, string2);
        }
    }

    private void namespace(OutputNode outputNode) {
        if (this.primary != null) {
            String string = this.primary.reference();
            outputNode.setReference(string);
        }
    }
}

