/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.Model;
import org.simpleframework.xml.core.ModelList;
import org.simpleframework.xml.core.PathException;

class ModelMap
extends LinkedHashMap<String, ModelList>
implements Iterable<ModelList> {
    private final Detail detail;

    public ModelMap(Detail detail) {
        this.detail = detail;
    }

    public ModelMap getModels() throws Exception {
        ModelMap modelMap = new ModelMap(this.detail);
        for (String string : this.keySet()) {
            ModelList modelList = (ModelList)this.get(string);
            if (modelList != null) {
                modelList = modelList.build();
            }
            if (modelMap.containsKey(string)) {
                throw new PathException("Path with name '%s' is a duplicate in %s ", string, this.detail);
            }
            modelMap.put(string, modelList);
        }
        return modelMap;
    }

    public Model lookup(String string, int n) {
        ModelList modelList = (ModelList)this.get(string);
        if (modelList != null) {
            return modelList.lookup(n);
        }
        return null;
    }

    public void register(String string, Model model) {
        ModelList modelList = (ModelList)this.get(string);
        if (modelList == null) {
            modelList = new ModelList();
            this.put(string, modelList);
        }
        modelList.register(model);
    }

    @Override
    public Iterator<ModelList> iterator() {
        return this.values().iterator();
    }
}

