/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.DefaultType;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.ElementMapUnion;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.Transient;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.ContactList;
import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.MethodContact;
import org.simpleframework.xml.core.MethodDetail;
import org.simpleframework.xml.core.MethodException;
import org.simpleframework.xml.core.MethodPart;
import org.simpleframework.xml.core.MethodPartFactory;
import org.simpleframework.xml.core.MethodType;
import org.simpleframework.xml.core.Support;

class MethodScanner
extends ContactList {
    private final MethodPartFactory factory;
    private final Support support;
    private final PartMap write;
    private final PartMap read;
    private final Detail detail;

    public MethodScanner(Detail detail, Support support) throws Exception {
        this.factory = new MethodPartFactory(detail, support);
        this.write = new PartMap();
        this.read = new PartMap();
        this.support = support;
        this.detail = detail;
        this.scan(detail);
    }

    private void scan(Detail detail) throws Exception {
        DefaultType defaultType = detail.getOverride();
        DefaultType defaultType2 = detail.getAccess();
        Class clazz = detail.getSuper();
        if (clazz != null) {
            this.extend(clazz, defaultType);
        }
        this.extract(detail, defaultType2);
        this.extract(detail);
        this.build();
        this.validate();
    }

    private void extend(Class clazz, DefaultType defaultType) throws Exception {
        ContactList contactList = this.support.getMethods(clazz, defaultType);
        for (Contact contact : contactList) {
            this.process((MethodContact)contact);
        }
    }

    private void extract(Detail detail) throws Exception {
        List<MethodDetail> list = detail.getMethods();
        for (MethodDetail methodDetail : list) {
            Annotation[] annotationArray = methodDetail.getAnnotations();
            Method method = methodDetail.getMethod();
            for (Annotation annotation : annotationArray) {
                this.scan(method, annotation, annotationArray);
            }
        }
    }

    private void extract(Detail detail, DefaultType defaultType) throws Exception {
        List<MethodDetail> list = detail.getMethods();
        if (defaultType == DefaultType.PROPERTY) {
            for (MethodDetail methodDetail : list) {
                Annotation[] annotationArray = methodDetail.getAnnotations();
                Method method = methodDetail.getMethod();
                Class clazz = this.factory.getType(method);
                if (clazz == null) continue;
                this.process(method, annotationArray);
            }
        }
    }

    private void scan(Method method, Annotation annotation, Annotation[] annotationArray) throws Exception {
        if (annotation instanceof Attribute) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementUnion) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementListUnion) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementMapUnion) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementList) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementArray) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementMap) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof Element) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof Version) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof Text) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof Transient) {
            this.remove(method, annotation, annotationArray);
        }
    }

    private void process(Method method, Annotation annotation, Annotation[] annotationArray) throws Exception {
        MethodPart methodPart = this.factory.getInstance(method, annotation, annotationArray);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.process(methodPart, this.write);
        }
    }

    private void process(Method method, Annotation[] annotationArray) throws Exception {
        MethodPart methodPart = this.factory.getInstance(method, annotationArray);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.process(methodPart, this.write);
        }
    }

    private void process(MethodPart methodPart, PartMap partMap) {
        String string = methodPart.getName();
        if (string != null) {
            partMap.put(string, methodPart);
        }
    }

    private void process(MethodContact methodContact) {
        MethodPart methodPart = methodContact.getRead();
        MethodPart methodPart2 = methodContact.getWrite();
        if (methodPart2 != null) {
            this.insert(methodPart2, this.write);
        }
        this.insert(methodPart, this.read);
    }

    private void insert(MethodPart methodPart, PartMap partMap) {
        String string = methodPart.getName();
        MethodPart methodPart2 = (MethodPart)partMap.remove(string);
        if (methodPart2 != null && this.isText(methodPart)) {
            methodPart = methodPart2;
        }
        partMap.put(string, methodPart);
    }

    private boolean isText(MethodPart methodPart) {
        Annotation annotation = methodPart.getAnnotation();
        return annotation instanceof Text;
    }

    private void remove(Method method, Annotation annotation, Annotation[] annotationArray) throws Exception {
        MethodPart methodPart = this.factory.getInstance(method, annotation, annotationArray);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.remove(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.remove(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.remove(methodPart, this.write);
        }
    }

    private void remove(MethodPart methodPart, PartMap partMap) throws Exception {
        String string = methodPart.getName();
        if (string != null) {
            partMap.remove(string);
        }
    }

    private void build() throws Exception {
        for (String string : this.read) {
            MethodPart methodPart = (MethodPart)this.read.get(string);
            if (methodPart == null) continue;
            this.build(methodPart, string);
        }
    }

    private void build(MethodPart methodPart, String string) throws Exception {
        MethodPart methodPart2 = this.write.take(string);
        if (methodPart2 != null) {
            this.build(methodPart, methodPart2);
        } else {
            this.build(methodPart);
        }
    }

    private void build(MethodPart methodPart) throws Exception {
        this.add(new MethodContact(methodPart));
    }

    private void build(MethodPart methodPart, MethodPart methodPart2) throws Exception {
        Annotation annotation = methodPart.getAnnotation();
        String string = methodPart.getName();
        if (!((Object)methodPart2.getAnnotation()).equals(annotation)) {
            throw new MethodException("Annotations do not match for '%s' in %s", string, this.detail);
        }
        Class clazz = methodPart.getType();
        if (clazz != methodPart2.getType()) {
            throw new MethodException("Method types do not match for %s in %s", string, clazz);
        }
        this.add(new MethodContact(methodPart, methodPart2));
    }

    private void validate() throws Exception {
        for (String string : this.write) {
            MethodPart methodPart = (MethodPart)this.write.get(string);
            if (methodPart == null) continue;
            this.validate(methodPart, string);
        }
    }

    private void validate(MethodPart methodPart, String string) throws Exception {
        MethodPart methodPart2 = this.read.take(string);
        Method method = methodPart.getMethod();
        if (methodPart2 == null) {
            throw new MethodException("No matching get method for %s in %s", method, this.detail);
        }
    }

    private static class PartMap
    extends LinkedHashMap<String, MethodPart>
    implements Iterable<String> {
        private PartMap() {
        }

        @Override
        public Iterator<String> iterator() {
            return this.keySet().iterator();
        }

        public MethodPart take(String string) {
            return (MethodPart)this.remove(string);
        }
    }
}

