/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.Policy;

class LabelMap
extends LinkedHashMap<String, Label>
implements Iterable<Label> {
    private final Policy policy;

    public LabelMap() {
        this((Policy)null);
    }

    public LabelMap(Policy policy) {
        this.policy = policy;
    }

    @Override
    public Iterator<Label> iterator() {
        return this.values().iterator();
    }

    public Label getLabel(String string) {
        return (Label)this.remove(string);
    }

    public String[] getKeys() throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        for (Label label : this) {
            if (label == null) continue;
            String string = label.getPath();
            String string2 = label.getName();
            hashSet.add(string);
            hashSet.add(string2);
        }
        return this.getArray(hashSet);
    }

    public String[] getPaths() throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        for (Label label : this) {
            if (label == null) continue;
            String string = label.getPath();
            hashSet.add(string);
        }
        return this.getArray(hashSet);
    }

    public LabelMap getLabels() throws Exception {
        LabelMap labelMap = new LabelMap(this.policy);
        for (Label label : this) {
            if (label == null) continue;
            String string = label.getPath();
            labelMap.put(string, label);
        }
        return labelMap;
    }

    private String[] getArray(Set<String> set) {
        return set.toArray(new String[0]);
    }

    public boolean isStrict(Context context) {
        if (this.policy == null) {
            return context.isStrict();
        }
        return context.isStrict() && this.policy.isStrict();
    }
}

