/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.ElementMapUnion;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.AttributeLabel;
import org.simpleframework.xml.core.CacheLabel;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.ElementArrayLabel;
import org.simpleframework.xml.core.ElementLabel;
import org.simpleframework.xml.core.ElementListLabel;
import org.simpleframework.xml.core.ElementListUnionLabel;
import org.simpleframework.xml.core.ElementMapLabel;
import org.simpleframework.xml.core.ElementMapUnionLabel;
import org.simpleframework.xml.core.ElementUnionLabel;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelGroup;
import org.simpleframework.xml.core.LabelKey;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.TextLabel;
import org.simpleframework.xml.core.VersionLabel;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class LabelExtractor {
    private final Cache<LabelGroup> cache = new ConcurrentCache<LabelGroup>();
    private final Format format;

    public LabelExtractor(Format format) {
        this.format = format;
    }

    public Label getLabel(Contact contact, Annotation annotation) throws Exception {
        Object object = this.getKey(contact, annotation);
        LabelGroup labelGroup = this.getGroup(contact, annotation, object);
        if (labelGroup != null) {
            return labelGroup.getPrimary();
        }
        return null;
    }

    public List<Label> getList(Contact contact, Annotation annotation) throws Exception {
        Object object = this.getKey(contact, annotation);
        LabelGroup labelGroup = this.getGroup(contact, annotation, object);
        if (labelGroup != null) {
            return labelGroup.getList();
        }
        return Collections.emptyList();
    }

    private LabelGroup getGroup(Contact contact, Annotation annotation, Object object) throws Exception {
        LabelGroup labelGroup = this.cache.fetch(object);
        if (labelGroup == null) {
            LabelGroup labelGroup2 = this.getLabels(contact, annotation);
            if (labelGroup2 != null) {
                this.cache.cache(object, labelGroup2);
            }
            return labelGroup2;
        }
        return labelGroup;
    }

    private LabelGroup getLabels(Contact contact, Annotation annotation) throws Exception {
        if (annotation instanceof ElementUnion) {
            return this.getUnion(contact, annotation);
        }
        if (annotation instanceof ElementListUnion) {
            return this.getUnion(contact, annotation);
        }
        if (annotation instanceof ElementMapUnion) {
            return this.getUnion(contact, annotation);
        }
        return this.getSingle(contact, annotation);
    }

    private LabelGroup getSingle(Contact contact, Annotation annotation) throws Exception {
        Label label = this.getLabel(contact, annotation, null);
        if (label != null) {
            label = new CacheLabel(label);
        }
        return new LabelGroup(label);
    }

    private LabelGroup getUnion(Contact contact, Annotation annotation) throws Exception {
        Annotation[] annotationArray = this.getAnnotations(annotation);
        if (annotationArray.length > 0) {
            LinkedList<Label> linkedList = new LinkedList<Label>();
            for (Annotation annotation2 : annotationArray) {
                Label label = this.getLabel(contact, annotation, annotation2);
                if (label != null) {
                    label = new CacheLabel(label);
                }
                linkedList.add(label);
            }
            return new LabelGroup(linkedList);
        }
        return null;
    }

    private Annotation[] getAnnotations(Annotation annotation) throws Exception {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length > 0) {
            Method method = methodArray[0];
            Object object = method.invoke((Object)annotation, new Object[0]);
            return (Annotation[])object;
        }
        return new Annotation[0];
    }

    private Label getLabel(Contact contact, Annotation annotation, Annotation annotation2) throws Exception {
        Constructor constructor = this.getConstructor(annotation);
        if (annotation2 != null) {
            return (Label)constructor.newInstance(contact, annotation, annotation2, this.format);
        }
        return (Label)constructor.newInstance(contact, annotation, this.format);
    }

    private Object getKey(Contact contact, Annotation annotation) {
        return new LabelKey(contact, annotation);
    }

    private Constructor getConstructor(Annotation annotation) throws Exception {
        LabelBuilder labelBuilder = this.getBuilder(annotation);
        Constructor constructor = labelBuilder.getConstructor();
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    private LabelBuilder getBuilder(Annotation annotation) throws Exception {
        if (annotation instanceof Element) {
            return new LabelBuilder(ElementLabel.class, Element.class);
        }
        if (annotation instanceof ElementList) {
            return new LabelBuilder(ElementListLabel.class, ElementList.class);
        }
        if (annotation instanceof ElementArray) {
            return new LabelBuilder(ElementArrayLabel.class, ElementArray.class);
        }
        if (annotation instanceof ElementMap) {
            return new LabelBuilder(ElementMapLabel.class, ElementMap.class);
        }
        if (annotation instanceof ElementUnion) {
            return new LabelBuilder(ElementUnionLabel.class, ElementUnion.class, Element.class);
        }
        if (annotation instanceof ElementListUnion) {
            return new LabelBuilder(ElementListUnionLabel.class, ElementListUnion.class, ElementList.class);
        }
        if (annotation instanceof ElementMapUnion) {
            return new LabelBuilder(ElementMapUnionLabel.class, ElementMapUnion.class, ElementMap.class);
        }
        if (annotation instanceof Attribute) {
            return new LabelBuilder(AttributeLabel.class, Attribute.class);
        }
        if (annotation instanceof Version) {
            return new LabelBuilder(VersionLabel.class, Version.class);
        }
        if (annotation instanceof Text) {
            return new LabelBuilder(TextLabel.class, Text.class);
        }
        throw new PersistenceException("Annotation %s not supported", annotation);
    }

    private static class LabelBuilder {
        private final Class label;
        private final Class entry;
        private final Class type;

        public LabelBuilder(Class clazz, Class clazz2) {
            this(clazz, clazz2, null);
        }

        public LabelBuilder(Class clazz, Class clazz2, Class clazz3) {
            this.entry = clazz3;
            this.label = clazz2;
            this.type = clazz;
        }

        public Constructor getConstructor() throws Exception {
            if (this.entry != null) {
                return this.getConstructor(this.label, this.entry);
            }
            return this.getConstructor(this.label);
        }

        private Constructor getConstructor(Class clazz) throws Exception {
            return this.type.getConstructor(Contact.class, clazz, Format.class);
        }

        private Constructor getConstructor(Class clazz, Class clazz2) throws Exception {
            return this.type.getConstructor(Contact.class, clazz, clazz2, Format.class);
        }
    }
}

