/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.core.CacheLabel;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Extractor;
import org.simpleframework.xml.core.ExtractorFactory;
import org.simpleframework.xml.core.Group;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.TextListLabel;
import org.simpleframework.xml.stream.Format;

class GroupExtractor
implements Group {
    private final ExtractorFactory factory;
    private final Annotation label;
    private final Registry registry;
    private final LabelMap elements;

    public GroupExtractor(Contact contact, Annotation annotation, Format format) throws Exception {
        this.factory = new ExtractorFactory(contact, annotation, format);
        this.elements = new LabelMap();
        this.registry = new Registry(this.elements);
        this.label = annotation;
        this.extract();
    }

    public String[] getNames() throws Exception {
        return this.elements.getKeys();
    }

    public String[] getPaths() throws Exception {
        return this.elements.getPaths();
    }

    @Override
    public LabelMap getElements() throws Exception {
        return this.elements.getLabels();
    }

    @Override
    public Label getLabel(Class clazz) {
        return this.registry.resolve(clazz);
    }

    @Override
    public Label getText() {
        return this.registry.resolveText();
    }

    public boolean isValid(Class clazz) {
        return this.registry.resolve(clazz) != null;
    }

    public boolean isDeclared(Class clazz) {
        return this.registry.containsKey(clazz);
    }

    @Override
    public boolean isInline() {
        for (Label label : this.registry) {
            if (label.isInline()) continue;
            return false;
        }
        return !this.registry.isEmpty();
    }

    @Override
    public boolean isTextList() {
        return this.registry.isText();
    }

    private void extract() throws Exception {
        Extractor extractor = this.factory.getInstance();
        if (extractor != null) {
            this.extract(extractor);
        }
    }

    private void extract(Extractor extractor) throws Exception {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = extractor.getAnnotations()) {
            this.extract(extractor, annotation);
        }
    }

    private void extract(Extractor extractor, Annotation annotation) throws Exception {
        Label label = extractor.getLabel(annotation);
        Class clazz = extractor.getType(annotation);
        if (this.registry != null) {
            this.registry.register(clazz, label);
        }
    }

    @Override
    public String toString() {
        return ((Object)this.label).toString();
    }

    private static class Registry
    extends LinkedHashMap<Class, Label>
    implements Iterable<Label> {
        private LabelMap elements;
        private Label text;

        public Registry(LabelMap labelMap) {
            this.elements = labelMap;
        }

        public boolean isText() {
            return this.text != null;
        }

        @Override
        public Iterator<Label> iterator() {
            return this.values().iterator();
        }

        public Label resolveText() {
            return this.resolveText(String.class);
        }

        public Label resolve(Class clazz) {
            Label label = this.resolveText(clazz);
            if (label == null) {
                return this.resolveElement(clazz);
            }
            return label;
        }

        private Label resolveText(Class clazz) {
            if (this.text != null && clazz == String.class) {
                return this.text;
            }
            return null;
        }

        private Label resolveElement(Class clazz) {
            while (clazz != null) {
                Label label = (Label)this.get(clazz);
                if (label != null) {
                    return label;
                }
                clazz = clazz.getSuperclass();
            }
            return null;
        }

        public void register(Class clazz, Label label) throws Exception {
            CacheLabel cacheLabel = new CacheLabel(label);
            this.registerElement(clazz, cacheLabel);
            this.registerText(cacheLabel);
        }

        private void registerElement(Class clazz, Label label) throws Exception {
            String string = label.getName();
            if (!this.elements.containsKey(string)) {
                this.elements.put(string, label);
            }
            if (!this.containsKey(clazz)) {
                this.put(clazz, label);
            }
        }

        private void registerText(Label label) throws Exception {
            Contact contact = label.getContact();
            Text text = contact.getAnnotation(Text.class);
            if (text != null) {
                this.text = new TextListLabel(label, text);
            }
        }
    }
}

